/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import javax.annotation.Nonnull;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.TLVList;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;

public class DiscretionaryDataTemplate
extends TLVList {
    private final ASN1ObjectIdentifier objId;
    private final byte[] data;

    public DiscretionaryDataTemplate(@Nonnull TLV tlv) throws TLVException {
        super(tlv, new Tag(TagClass.APPLICATION, false, 19L));
        Parser p = new Parser(tlv.getChild());
        if (p.match(Tag.OID_TAG)) {
            try {
                String oidStr = ObjectIdentifierUtils.toString(p.next(0).getValue());
                this.objId = new ASN1ObjectIdentifier(oidStr);
            }
            catch (IllegalArgumentException ex) {
                throw new TLVException(ex);
            }
        } else {
            throw new TLVException("Object Identifier is missing in DiscretionaryDataTemplate.");
        }
        if (!p.match(new Tag(TagClass.APPLICATION, true, 19L))) {
            throw new TLVException("Discretionary Data is missing in DiscretionaryDataTemplate.");
        }
        this.data = p.next(0).getValue();
    }

    public ASN1ObjectIdentifier getObjectIdentifier() {
        return this.objId;
    }

    public byte[] getDiscretionaryData() {
        return ByteUtils.clone(this.data);
    }
}

