/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.handler;

import java.io.IOException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.entity.StringEntity;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.control.binding.http.HttpException;
import org.openecard.control.binding.http.common.Http11Response;
import org.openecard.control.binding.http.handler.HttpControlHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControlCommonHandler
extends HttpControlHandler {
    private static final Logger _logger = LoggerFactory.getLogger(ControlCommonHandler.class);

    protected ControlCommonHandler() {
        super("*");
    }

    protected ControlCommonHandler(String path) {
        super(path);
    }

    public abstract HttpResponse handle(HttpRequest var1) throws org.openecard.apache.http.HttpException, Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws org.openecard.apache.http.HttpException, IOException {
        _logger.debug("HTTP request: {}", (Object)request.toString());
        HttpResponse httpResponse = null;
        try {
            response.setParams(request.getParams());
            httpResponse = this.handle(request);
        }
        catch (HttpException e) {
            httpResponse = new Http11Response(400);
            httpResponse.setEntity(new StringEntity(e.getMessage(), "UTF-8"));
            if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                httpResponse.setEntity(new StringEntity(e.getMessage(), "UTF-8"));
            }
            httpResponse.setStatusCode(e.getHTTPStatusCode());
            Http11Response.copyHttpResponse(httpResponse, response);
            _logger.debug("HTTP response: {}", (Object)response);
            _logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
        }
        catch (Exception e2) {
            httpResponse = new Http11Response(500);
            _logger.error(e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    Http11Response.copyHttpResponse(httpResponse, response);
                    _logger.debug("HTTP response: {}", (Object)response);
                    _logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
                    throw throwable;
                }
            }
            Http11Response.copyHttpResponse(httpResponse, response);
            _logger.debug("HTTP response: {}", (Object)response);
            _logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
        }
        Http11Response.copyHttpResponse(httpResponse, response);
        _logger.debug("HTTP response: {}", (Object)response);
        _logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
    }
}

