/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.common;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRoot {
    private static final Logger _logger = LoggerFactory.getLogger(DocumentRoot.class);
    private Map<String, URL> files;

    public DocumentRoot(String rootPath, String listFile) throws IOException {
        try {
            this.files = FileUtils.getResourceFileListing(DocumentRoot.class, rootPath, listFile);
        }
        catch (IOException ex) {
            _logger.error("Invalid path {}", (Object)rootPath);
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    public boolean contains(String file) {
        return this.files.containsKey(file);
    }

    public List<URL> getFiles() {
        return new ArrayList<URL>(this.files.values());
    }

    public URL getFile(String fileName) {
        URL file = this.files.get(fileName);
        if (file == null) {
            _logger.error("Cannot load file: {} ", (Object)fileName);
        }
        return file;
    }
}

