/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.openecard.common.util.HttpRequestLineUtils;
import org.openecard.common.util.UrlEncoder;

@Immutable
public class UrlBuilder {
    private final UrlEncoder encoder;
    private String scheme;
    private String userInfo;
    private String host;
    private int port;
    private String path;
    private final HashMap<String, String> queryParams;
    private String fragment;

    private UrlBuilder(UrlEncoder encoder, String scheme, String userInfo, String host, int port, String path, HashMap<String, String> queryParams, String fragment) {
        this.encoder = encoder;
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.queryParams = queryParams;
        this.fragment = fragment;
    }

    private UrlBuilder(UrlBuilder other) {
        this.encoder = other.encoder;
        this.scheme = other.scheme;
        this.userInfo = other.userInfo;
        this.host = other.host;
        this.port = other.port;
        this.path = other.path;
        this.queryParams = new HashMap<String, String>(other.queryParams);
        this.fragment = other.fragment;
    }

    public static UrlBuilder fromUrl(URI baseUri) {
        UrlEncoder encoder = new UrlEncoder();
        String scheme = baseUri.getScheme();
        String userInfo = baseUri.getRawUserInfo();
        String host = baseUri.getHost();
        int port = baseUri.getPort();
        String path = baseUri.getRawPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        HashMap<String, String> queryParams = new HashMap<String, String>(HttpRequestLineUtils.transformRaw(baseUri.getRawQuery()));
        String fragment = baseUri.getRawFragment();
        return new UrlBuilder(encoder, scheme, userInfo, host, port, path, queryParams, fragment);
    }

    public static UrlBuilder fromUrl(URL baseUrl) throws URISyntaxException {
        return UrlBuilder.fromUrl(baseUrl.toURI());
    }

    public static UrlBuilder fromUrl(String baseUrl) throws URISyntaxException {
        return UrlBuilder.fromUrl(new URI(baseUrl));
    }

    public URI build() throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.scheme).append("://");
        if (this.userInfo != null) {
            sb.append(this.userInfo).append("@");
        }
        sb.append(this.host);
        if (this.port != -1) {
            sb.append(":").append(this.port);
        }
        sb.append(this.path);
        Iterator<Map.Entry<String, String>> it = this.queryParams.entrySet().iterator();
        if (it.hasNext()) {
            sb.append("?");
            while (it.hasNext()) {
                Map.Entry<String, String> element = it.next();
                String key = element.getKey();
                String val = element.getValue();
                sb.append(key);
                if (val != null) {
                    sb.append("=").append(val);
                }
                if (!it.hasNext()) continue;
                sb.append("&");
            }
        }
        if (this.fragment != null) {
            sb.append("#").append(this.fragment);
        }
        return new URI(sb.toString()).normalize();
    }

    public UrlBuilder scheme(@Nonnull String scheme) {
        UrlBuilder b = new UrlBuilder(this);
        b.scheme = scheme;
        return b;
    }

    public UrlBuilder userInfo(@Nonnull String userInfo) {
        UrlBuilder b = new UrlBuilder(this);
        b.userInfo = userInfo;
        return b;
    }

    public UrlBuilder host(@Nonnull String host) {
        UrlBuilder b = new UrlBuilder(this);
        b.host = host;
        return b;
    }

    public UrlBuilder port(int port) {
        UrlBuilder b = new UrlBuilder(this);
        b.port = port;
        return b;
    }

    public UrlBuilder replacePath(@Nullable String path) {
        UrlBuilder b = new UrlBuilder(this);
        if (path == null) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        b.path = path;
        return b;
    }

    public UrlBuilder addPathSegment(@Nonnull String segment) {
        UrlBuilder b = new UrlBuilder(this);
        if (!this.path.endsWith("/") && !segment.startsWith("/")) {
            segment = "/" + segment;
        }
        b.path = this.path + segment;
        return b;
    }

    public UrlBuilder queryParam(@Nonnull String key, @Nullable String value) {
        return this.queryParam(key, value, true);
    }

    public UrlBuilder queryParamUrl(@Nonnull String key, @Nullable String value) {
        return this.queryParamUrl(key, value, true);
    }

    public UrlBuilder queryParam(@Nonnull String key, @Nullable String value, boolean overwrite) {
        UrlBuilder b = new UrlBuilder(this);
        if (overwrite || !this.queryParams.containsKey(key)) {
            b.addQueryInt(key, value);
        }
        return b;
    }

    public UrlBuilder queryParamUrl(@Nonnull String key, @Nullable String value, boolean overwrite) {
        UrlBuilder b = new UrlBuilder(this);
        if (overwrite || !this.queryParams.containsKey(key)) {
            b.addQueryInt(key, this.encoder.urlEncodeUrl(value));
        }
        return b;
    }

    public UrlBuilder removeQueryParams() {
        UrlBuilder b = new UrlBuilder(this);
        b.queryParams.clear();
        return b;
    }

    public UrlBuilder fragment(@Nullable String fragment) {
        UrlBuilder b = new UrlBuilder(this);
        b.fragment = this.encoder.encodeFragment(fragment);
        return b;
    }

    private void addQueryInt(@Nonnull String k, @Nullable String v) {
        k = this.encoder.encodeQueryParam(k);
        v = this.encoder.encodeQueryParam(v);
        this.queryParams.put(k, v);
    }
}

