/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringUtils {
    private static final Pattern WS_PATTERN = Pattern.compile("\\s");

    public static byte[] toByteArray(@Nonnull String hex) {
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        byte[] ret = new byte[hex.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
        }
        return ret;
    }

    public static byte[] toByteArray(@Nonnull String hex, boolean removeWhitespace) {
        if (removeWhitespace) {
            hex = WS_PATTERN.matcher(hex).replaceAll("");
        }
        return StringUtils.toByteArray(hex);
    }

    public static boolean isNullOrEmpty(@Nullable String value) {
        return value == null || value.isEmpty();
    }

    @Nonnull
    public static String nullToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }

    @Nullable
    public static String emptyToNull(@Nullable String s) {
        return s != null && s.isEmpty() ? null : s;
    }
}

