/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationListResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDList;
import iso.std.iso_iec._24727.tech.schema.DIDListResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetList;
import iso.std.iso_iec._24727.tech.schema.DataSetListResponse;
import java.util.List;
import javax.annotation.Nonnull;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.HandlerUtils;

public class SALFileUtils {
    private final Dispatcher dispatcher;

    public SALFileUtils(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Nonnull
    public ConnectionHandleType selectAppByDataSet(@Nonnull String dataSetName, @Nonnull ConnectionHandleType handle) throws WSHelper.WSException {
        handle = HandlerUtils.copyHandle(handle);
        CardApplicationList cardApps = new CardApplicationList();
        cardApps.setConnectionHandle(handle);
        CardApplicationListResponse cardAppsResp = (CardApplicationListResponse)this.dispatcher.safeDeliver(cardApps);
        WSHelper.checkResult(cardAppsResp);
        List<byte[]> cardApplications = cardAppsResp.getCardApplicationNameList().getCardApplicationName();
        for (byte[] app : cardApplications) {
            DataSetList dataSetListReq = new DataSetList();
            handle.setCardApplication(app);
            dataSetListReq.setConnectionHandle(handle);
            DataSetListResponse dataSetListResp = (DataSetListResponse)this.dispatcher.safeDeliver(dataSetListReq);
            WSHelper.checkResult(dataSetListResp);
            if (!dataSetListResp.getDataSetNameList().getDataSetName().contains(dataSetName)) continue;
            handle = this.selectApplication(app, handle);
            return handle;
        }
        String msg = "Failed to find the requested data set (%s) in any of the applications of the specified card.";
        msg = String.format(msg, dataSetName);
        Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#fileNotFound", msg);
        throw WSHelper.createException(r);
    }

    @Nonnull
    public ConnectionHandleType selectAppByDID(@Nonnull String didName, @Nonnull ConnectionHandleType handle) throws WSHelper.WSException {
        handle = HandlerUtils.copyHandle(handle);
        CardApplicationList cardApps = new CardApplicationList();
        cardApps.setConnectionHandle(handle);
        CardApplicationListResponse cardAppsResp = (CardApplicationListResponse)this.dispatcher.safeDeliver(cardApps);
        WSHelper.checkResult(cardAppsResp);
        List<byte[]> cardApplications = cardAppsResp.getCardApplicationNameList().getCardApplicationName();
        for (byte[] app : cardApplications) {
            DIDList didListReq = new DIDList();
            handle.setCardApplication(app);
            didListReq.setConnectionHandle(handle);
            DIDListResponse didListResp = (DIDListResponse)this.dispatcher.safeDeliver(didListReq);
            WSHelper.checkResult(didListResp);
            if (!didListResp.getDIDNameList().getDIDName().contains(didName)) continue;
            handle = this.selectApplication(app, handle);
            return handle;
        }
        String msg = "Failed to find the requested DID (%s) in any of the applications of the specified card.";
        msg = String.format(msg, didName);
        Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#fileNotFound", msg);
        throw WSHelper.createException(r);
    }

    public ConnectionHandleType selectApplication(@Nonnull byte[] appId, @Nonnull ConnectionHandleType handle) throws WSHelper.WSException {
        CardApplicationConnect appConnectReq = new CardApplicationConnect();
        CardApplicationPathType path = HandlerUtils.copyPath(handle);
        path.setCardApplication(appId);
        appConnectReq.setCardApplicationPath(path);
        CardApplicationConnectResponse resp = (CardApplicationConnectResponse)this.dispatcher.safeDeliver(appConnectReq);
        WSHelper.checkResult(resp);
        return resp.getConnectionHandle();
    }
}

