/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class HTMLUtils {
    private static final Map<Character, String> HTML_ESCAPES = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('&'), "&amp;");
            this.put(Character.valueOf('<'), "&lt;");
            this.put(Character.valueOf('>'), "&gt;");
            this.put(Character.valueOf('\"'), "&quot;");
            this.put(Character.valueOf('\''), "&#x27;");
            this.put(Character.valueOf('/'), "&#x2F;");
        }
    };
    private static final Pattern NEEDS_ATTRIBUTE_ESCAPE = Pattern.compile("\\p{Alnum}");

    @Nullable
    public static String escapeHtml(@Nullable String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            result.append(HTMLUtils.encodeChar(Character.valueOf(input.charAt(i)), HTML_ESCAPES));
        }
        return result.toString();
    }

    public static String escapeAttribute(@Nullable String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c < '\u0100' && NEEDS_ATTRIBUTE_ESCAPE.matcher(String.valueOf(c)).matches()) {
                result.append("&#x");
                result.append(String.format("%02x", (byte)c));
                result.append(";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static String encodeChar(Character c, Map<Character, String> mapping) {
        String encoded = mapping.get(c);
        if (encoded == null) {
            return c.toString();
        }
        return encoded;
    }
}

