/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.openecard.common.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuturePromise<T>
extends Promise<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FuturePromise.class);
    private static final AtomicInteger THREAD_NUM = new AtomicInteger(1);

    public FuturePromise(final Callable<T> function) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = function.call();
                }
                catch (Exception ex) {
                    LOG.error("Failed to complete computation of the result.", ex);
                    result = null;
                }
                FuturePromise.super.deliver(result);
            }
        }, "FuturePromise-" + THREAD_NUM.getAndIncrement()).start();
    }

    @Override
    public synchronized T deliver(T value) throws IllegalStateException {
        throw new IllegalStateException("The promise is already delivered.");
    }
}

