/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.openecard.common.io.LimitedInputStream;

public class FileUtils {
    public static File getHomeConfigDir() throws IOException, SecurityException {
        String dirName = "openecard";
        String home = System.getProperty("user.home");
        if (home != null) {
            String pathname = home + File.separator + "." + "openecard";
            File path = new File(pathname);
            path.mkdirs();
            return path;
        }
        throw new IOException("Home path can not be determined.");
    }

    public static File getAddonsDir() throws IOException, SecurityException {
        File path = new File(FileUtils.getHomeConfigDir(), "addons");
        path.mkdirs();
        return path;
    }

    public static File getAddonsConfDir() throws IOException, SecurityException {
        File path = new File(FileUtils.getAddonsDir(), "conf");
        path.mkdirs();
        return path;
    }

    public static byte[] toByteArray(File file) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        return FileUtils.toByteArray(is);
    }

    public static byte[] toByteArray(File file, int limit) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new LimitedInputStream(new FileInputStream(file)), limit);
        return FileUtils.toByteArray(is);
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((i = is.read(buffer)) != -1) {
            baos.write(buffer, 0, i);
        }
        return baos.toByteArray();
    }

    public static String toString(File file) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        return FileUtils.toString(new FileInputStream(file));
    }

    public static String toString(File file, String charset) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        return FileUtils.toString(new FileInputStream(file), charset);
    }

    public static String toString(InputStream in) throws UnsupportedEncodingException, IOException {
        return FileUtils.toString(in, "UTF-8");
    }

    public static String toString(InputStream in, String charset) throws UnsupportedEncodingException, IOException {
        return new String(FileUtils.toByteArray(in), charset);
    }

    public static Map<String, URL> getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            File dirFile = new File(dirURL.toURI());
            return FileUtils.getSubdirFileListing(dirFile, dirURL.toExternalForm());
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            String jarUrl = dirURL.toExternalForm().substring(0, dirURL.toExternalForm().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            TreeMap<String, URL> result = new TreeMap<String, URL>();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry nextEntry = entries.nextElement();
                if (nextEntry.isDirectory() || !(name = nextEntry.getName()).startsWith(path)) continue;
                String entryPath = jarUrl + "!/" + name;
                String prefix = "/" + name.substring(path.length());
                result.put(prefix, new URL(entryPath));
            }
            return result;
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    private static TreeMap<String, URL> getSubdirFileListing(File dir, String base) throws MalformedURLException {
        TreeMap<String, URL> resultList = new TreeMap<String, URL>();
        for (File next : dir.listFiles()) {
            if (next.canRead() && next.isDirectory()) {
                resultList.putAll(FileUtils.getSubdirFileListing(next, base));
                continue;
            }
            if (!next.canRead() || !next.isFile()) continue;
            URL fileURL = next.toURI().toURL();
            String prefix = fileURL.toExternalForm().substring(base.length() - 1);
            resultList.put(prefix, fileURL);
        }
        return resultList;
    }

    public static Map<String, URL> getResourceFileListing(Class clazz, String prefix, String listFile) throws UnsupportedEncodingException, IOException {
        InputStream fileStream = FileUtils.resolveResourceAsStream(clazz, listFile);
        String fileValue = FileUtils.toString(fileStream);
        String[] files = fileValue.split(":");
        TreeMap<String, URL> result = new TreeMap<String, URL>();
        for (String file : files) {
            URL fileUrl = FileUtils.resolveResourceAsURL(clazz, file);
            if (fileUrl == null) continue;
            result.put(file.substring(prefix.length()), fileUrl);
        }
        return result;
    }

    public static InputStream resolveResourceAsStream(Class clazz, String name) throws IOException {
        URL url = FileUtils.resolveResourceAsURL(clazz, name);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static URL resolveResourceAsURL(Class clazz, String name) {
        URL url = clazz.getResource(name);
        if (url == null) {
            name = name.startsWith("/") ? name.substring(1) : "/" + name;
            url = clazz.getResource(name);
        }
        return url;
    }

    public static InputStream resolveResourceAsStream(ClassLoader loader, String name) throws IOException {
        URL url = FileUtils.resolveResourceAsURL(loader, name);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    @Nullable
    public static URL resolveResourceAsURL(ClassLoader loader, String name) {
        URL url = loader.getResource(name);
        if (url == null) {
            name = name.startsWith("/") ? name.substring(1) : "/" + name;
            url = loader.getResource(name);
        }
        return url;
    }

    public static List<String> readLinesFromConfig(InputStream in) {
        return FileUtils.readLinesFromConfig(in, "UTF-8");
    }

    public static List<String> readLinesFromConfig(InputStream in, String charset) {
        ArrayList<String> result = new ArrayList<String>();
        Scanner s = new Scanner(in, charset);
        while (s.hasNextLine()) {
            String next = s.nextLine().trim();
            if (next.isEmpty() || next.startsWith("#")) continue;
            result.add(next);
        }
        return result;
    }
}

