/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.util.LinkedList;
import java.util.List;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;

public class TLVList {
    protected final TLV tlv;

    protected TLVList(TLV tlv, Tag expectedTag) throws TLVException {
        this(tlv, expectedTag.getTagNumWithClass());
    }

    protected TLVList(TLV tlv, long expectedTagNum) throws TLVException {
        if (tlv.getTagNumWithClass() != expectedTagNum) {
            throw new TLVException("Not of type TLVList.");
        }
        this.tlv = tlv;
    }

    public TLVList(List<TLV> children) throws TLVException {
        this.tlv = new TLV();
        this.tlv.setTagNumWithClass(Tag.SEQUENCE_TAG.getTagNumWithClass());
        if (!children.isEmpty()) {
            TLV first = children.get(0);
            this.tlv.setChild(first);
            for (int i = 1; i < children.size(); ++i) {
                first.addToEnd(children.get(i));
            }
        }
    }

    public TLVList(TLV tlv) throws TLVException {
        this(tlv, 97L);
    }

    public TLVList(byte[] data) throws TLVException {
        this(TLV.fromBER(data));
    }

    public final List<TLV> getContent() {
        if (this.tlv.hasChild()) {
            return this.tlv.getChild().asList();
        }
        return new LinkedList<TLV>();
    }
}

