/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.GenericSecretKeyObject;
import org.openecard.common.tlv.iso7816.TLVType;

public class SecretKeyChoice
extends TLVType {
    private GenericSecretKeyObject<TLV> algIndependentKey = null;
    private GenericSecretKeyObject<TLV> genericSecretKey = null;
    private TLV extension = null;

    public SecretKeyChoice(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (p.match(Tag.SEQUENCE_TAG)) {
            this.algIndependentKey = new GenericSecretKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 15L))) {
            this.genericSecretKey = new GenericSecretKeyObject<TLV>(p.next(0), TLV.class);
        } else {
            this.extension = p.next(0);
        }
    }

    public GenericSecretKeyObject<TLV> getAlgIndependentKey() {
        return this.algIndependentKey;
    }

    public GenericSecretKeyObject<TLV> getGenericSecretKey() {
        return this.genericSecretKey;
    }

    public TLV getExtension() {
        return this.extension;
    }
}

