/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.Path;
import org.openecard.common.tlv.iso7816.TLVBitString;
import org.openecard.common.tlv.iso7816.TLVType;

public class PrivateRSAKeyAttributes
extends TLVType {
    private Path value;
    private byte[] modulusLength;
    private TLV parameters;
    private TLVBitString operations;

    public PrivateRSAKeyAttributes(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (!p.match(Tag.SEQUENCE_TAG)) {
            throw new TLVException("No value element in structure.");
        }
        this.value = new Path(p.next(0));
        if (!p.match(Tag.INTEGER_TAG)) {
            throw new TLVException("No modulusLength element in structure.");
        }
        this.modulusLength = p.next(0).getValue();
        if (p.match(Tag.SEQUENCE_TAG)) {
            Parser p1 = new Parser(p.next(0).getChild());
            if (!p1.match(Tag.NULL_TAG)) {
                throw new TLVException("No parameters element in structure.");
            }
            this.parameters = p1.next(0);
            if (p1.match(new Tag(TagClass.UNIVERSAL, true, 3L))) {
                this.operations = new TLVBitString(p1.next(0), new Tag(TagClass.UNIVERSAL, true, 3L).getTagNumWithClass());
            }
        }
    }

    public Path getValue() {
        return this.value;
    }

    public byte[] getModulusLength() {
        return this.modulusLength;
    }

    public TLV getParameters() {
        return this.parameters;
    }

    public TLVBitString getOperations() {
        return this.operations;
    }
}

