/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.Path;
import org.openecard.common.tlv.iso7816.TLVList;
import org.openecard.common.tlv.iso7816.TLVType;

public final class GenericPathOrObjects<KeyType extends TLVType>
extends TLV {
    private Path path;
    private List<KeyType> objects;
    private TLV ext;

    public GenericPathOrObjects(TLV tlv, Class<KeyType> clazz) throws TLVException {
        super(tlv);
        Constructor<KeyType> c;
        try {
            c = clazz.getConstructor(TLV.class);
        }
        catch (Exception ex) {
            throw new TLVException("KeyType supplied doesn't have a constructor KeyType(TLV).");
        }
        Parser p = new Parser(tlv.getChild());
        if (p.match(Tag.SEQUENCE_TAG)) {
            this.path = new Path(p.next(0));
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            Parser p1 = new Parser(p.next(0).getChild());
            if (p1.match(Tag.SEQUENCE_TAG)) {
                TLVList objectsList = new TLVList(p1.next(0));
                this.objects = new LinkedList<KeyType>();
                for (TLV nextT : objectsList.getContent()) {
                    try {
                        this.objects.add(c.newInstance(nextT));
                    }
                    catch (InvocationTargetException ex) {
                        throw new TLVException(ex);
                    }
                    catch (Exception ex) {
                        throw new TLVException("KeyType supplied doesn't have a constructor KeyType(TLV).");
                    }
                }
            }
        } else {
            this.ext = p.next(0);
            if (this.ext == null) {
                throw new TLVException("No content in PathOrObject type.");
            }
        }
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Path path() {
        return this.path;
    }

    public boolean hasObjects() {
        return this.objects != null;
    }

    public List<KeyType> objects() {
        return this.objects;
    }
}

