/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.GenericAuthenticationObject;
import org.openecard.common.tlv.iso7816.PasswordAttributes;
import org.openecard.common.tlv.iso7816.TLVType;

public class AuthenticationObjectChoice
extends TLVType {
    private GenericAuthenticationObject<PasswordAttributes> pwd;
    private GenericAuthenticationObject<TLV> biometricTemplate;
    private GenericAuthenticationObject<TLV> authKey;
    private GenericAuthenticationObject<TLV> external;
    private TLV ext;

    public AuthenticationObjectChoice(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv);
        if (p.match(new Tag(TagClass.UNIVERSAL, false, 16L))) {
            this.pwd = new GenericAuthenticationObject<PasswordAttributes>(p.next(0), PasswordAttributes.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.biometricTemplate = new GenericAuthenticationObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.authKey = new GenericAuthenticationObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 2L))) {
            this.external = new GenericAuthenticationObject<TLV>(p.next(0), TLV.class);
        } else {
            this.ext = p.next(0);
        }
    }

    public GenericAuthenticationObject<PasswordAttributes> getPasswordObject() {
        return this.pwd;
    }

    public GenericAuthenticationObject<TLV> getBiometricTemplate() {
        return this.biometricTemplate;
    }

    public GenericAuthenticationObject<TLV> getAuthenticationKey() {
        return this.authKey;
    }

    public GenericAuthenticationObject<TLV> getExternalAuthObject() {
        return this.external;
    }

    public TLV getFutureExtension() {
        return this.ext;
    }
}

