/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.CIODDO;
import org.openecard.common.tlv.iso7816.TLVList;
import org.openecard.common.util.ByteUtils;

public class ApplicationTemplate
extends TLVList {
    private byte[] applicationIdentifier;
    private byte[] applicationLabel;
    private byte[] fileReference;
    private byte[] commandAPDU;
    private byte[] discretionaryData;
    private CIODDO cioddo;
    private byte[] url;
    private TLVList appDataObjects;

    public ApplicationTemplate(TLV tlv) throws TLVException {
        super(tlv, 97L);
        Parser p = new Parser(tlv.getChild());
        if (!p.match(79L)) {
            throw new TLVException("No ApplicationIdentifier defined in ApplicationTemplate.");
        }
        this.applicationIdentifier = p.next(0).getValue();
        this.applicationLabel = null;
        if (p.match(80L)) {
            this.applicationLabel = p.next(0).getValue();
        }
        this.fileReference = null;
        if (p.match(81L)) {
            this.fileReference = p.next(0).getValue();
        }
        this.commandAPDU = null;
        if (p.match(82L)) {
            this.commandAPDU = p.next(0).getValue();
        }
        this.discretionaryData = null;
        if (p.match(83L)) {
            this.discretionaryData = p.next(0).getValue();
        }
        this.cioddo = null;
        if (p.match(115L)) {
            if (this.discretionaryData != null) {
                throw new TLVException("DiscretionaryData already defined. CIODDO is forbidden then.");
            }
            this.cioddo = new CIODDO(p.next(0));
        }
        this.url = null;
        if (p.match(24400L)) {
            this.url = p.next(0).getValue();
        }
        this.appDataObjects = null;
        if (p.match(97L)) {
            this.appDataObjects = new TLVList(p.next(0));
        }
    }

    public ApplicationTemplate(byte[] data) throws TLVException {
        this(TLV.fromBER(data));
    }

    public byte[] getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public boolean hasApplicationLabel() {
        return this.applicationLabel != null;
    }

    public byte[] getApplicationLabel() {
        return this.applicationLabel;
    }

    public boolean hasFileReference() {
        return this.fileReference != null;
    }

    public byte[] getFileReference() {
        return this.fileReference;
    }

    public boolean hasCommandAPDU() {
        return this.commandAPDU != null;
    }

    public byte[] getCommandAPDU() {
        return this.commandAPDU;
    }

    public boolean hasDiscretionaryData() {
        return this.discretionaryData != null;
    }

    public byte[] getDiscretionaryData() {
        return this.discretionaryData;
    }

    public boolean hasCIODDO() {
        return this.cioddo != null;
    }

    public CIODDO getCIODDO() {
        return this.cioddo;
    }

    public boolean hasURL() {
        return this.url != null;
    }

    public byte[] getURL() {
        return this.url;
    }

    public boolean hasApplicationDataObject() {
        return this.appDataObjects != null;
    }

    public TLVList getApplicationDataObjects() {
        return this.appDataObjects;
    }

    public boolean isCiaAid() {
        String aid = ByteUtils.toHexString(this.applicationIdentifier);
        if ((aid = aid.toUpperCase()).startsWith("E828BD080F")) {
            return true;
        }
        return aid.equals("A000000063504B43532D3135");
    }
}

