/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.TagLengthValue;
import org.openecard.common.util.ByteUtils;

public class TLV {
    private TagLengthValue tag;
    TLV next = null;
    TLV child = null;

    public TLV() {
        this.tag = new TagLengthValue();
    }

    public TLV(TLV obj) {
        this.tag = obj.tag;
        this.next = obj.next != null ? new TLV(obj.next) : null;
        this.child = obj.child != null ? new TLV(obj.child) : null;
    }

    public Tag getTag() {
        return this.tag.getTag();
    }

    public void setTag(Tag tag) {
        this.tag.setTag(tag);
    }

    public TagClass getTagClass() {
        return this.tag.getTagClass();
    }

    public void setTagClass(TagClass tagClass) {
        this.tag.setTagClass(tagClass);
    }

    public boolean isPrimitive() {
        return this.tag.isPrimitive();
    }

    public void setPrimitive(boolean primitive) {
        this.tag.setPrimitive(primitive);
    }

    public long getTagNum() {
        return this.tag.getTagNum();
    }

    public void setTagNum(byte tagNum) {
        this.setTagNum(tagNum & 0xFF);
    }

    public void setTagNum(long tagNum) {
        this.tag.setTagNum(tagNum);
    }

    public long getTagNumWithClass() {
        return this.tag.getTagNumWithClass();
    }

    public void setTagNumWithClass(byte tagNumWithClass) throws TLVException {
        this.setTagNumWithClass(tagNumWithClass & 0xFF);
    }

    public void setTagNumWithClass(long tagNumWithClass) throws TLVException {
        this.tag.setTagNumWithClass(tagNumWithClass);
    }

    public void setTagNumWithClass(byte[] tagNumWithClass) throws TLVException {
        this.tag.setTagNumWithClass(tagNumWithClass);
    }

    public int getValueLength() {
        return this.tag.getValueLength();
    }

    public byte[] getValue() {
        return this.tag.getValue();
    }

    public void setValue(byte[] value) {
        this.tag.setValue(value);
    }

    public void addToEnd(TLV sibling) {
        if (this.next == null) {
            this.next = sibling;
        } else {
            this.next.addToEnd(sibling);
        }
    }

    public TLV remove(int n) {
        if (n == 0) {
            TLV tmp = this.next;
            this.next = null;
            return tmp;
        }
        if (n > 0 && this.next != null) {
            return this.next.remove(n - 1);
        }
        return null;
    }

    public TLV removeNext() {
        return this.remove(0);
    }

    public void setChild(TLV child) {
        this.child = child;
    }

    public boolean hasChild() {
        return this.child != null;
    }

    public TLV getChild() {
        return this.child;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public TLV getNext() {
        return this.next;
    }

    public List<TLV> asList() {
        LinkedList<TLV> result = new LinkedList<TLV>();
        TLV nextTag = this;
        while (nextTag != null) {
            TLV toAdd = new TLV(nextTag);
            toAdd.next = null;
            result.add(toAdd);
            nextTag = nextTag.next;
        }
        return result;
    }

    public List<TLV> findNextTags(long num) {
        List<TLV> all = this.asList();
        LinkedList<TLV> result = new LinkedList<TLV>();
        for (TLV nextTLV : all) {
            if (nextTLV.getTagNumWithClass() != num) continue;
            result.add(nextTLV);
        }
        return result;
    }

    public List<TLV> findChildTags(long num) {
        if (this.hasChild()) {
            return this.getChild().findNextTags(num);
        }
        return new LinkedList<TLV>();
    }

    public static TLV fromBER(byte[] input) throws TLVException {
        byte[] rest = input;
        TLV first = new TLV();
        boolean isFirst = true;
        TLV last = first;
        while (rest.length > 0) {
            TLV next = isFirst ? first : new TLV();
            if (rest[0] == 0) {
                return first;
            }
            next.tag = TagLengthValue.fromBER(rest);
            if (!next.tag.isPrimitive() && next.tag.getValueLength() > 0) {
                next.child = TLV.fromBER(next.tag.getValue());
            }
            if (isFirst) {
                isFirst = false;
            } else {
                last.next = next;
            }
            last = next;
            rest = last.tag.extractRest(rest);
        }
        return first;
    }

    public byte[] toBER() {
        return this.toBER(false);
    }

    public byte[] toBER(boolean withSuccessors) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.toBER(out, withSuccessors);
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void toBER(ByteArrayOutputStream out, boolean withSuccessors) throws IOException {
        if (this.child != null) {
            byte[] childBytes = this.child.toBER(true);
            this.tag.setPrimitive(false);
            this.tag.setValue(childBytes);
        } else {
            this.tag.setPrimitive(true);
        }
        out.write(this.tag.toBER());
        if (withSuccessors && this.next != null) {
            this.next.toBER(out, withSuccessors);
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        String result = prefix + String.format("%02X", this.getTagNumWithClass());
        result = !this.hasChild() ? result + " " + this.tag.getValueLength() + " " + ByteUtils.toHexString(this.tag.getValue()) : result + "\n" + this.getChild().toString(prefix + "  ");
        if (this.hasNext()) {
            result = result + "\n" + this.getNext().toString(prefix);
        }
        return result;
    }
}

