/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv;

import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.Tag;

public class Parser {
    private final TLV tlv;
    private TLV next;

    public Parser(TLV tlv) {
        this.tlv = tlv;
        this.reset();
    }

    public final void reset() {
        this.next = this.tlv;
    }

    public boolean match(Tag ... tags) {
        return this.match(this.next, this.convertTags(tags));
    }

    public boolean match(long ... tagsWithClass) {
        return this.match(this.next, tagsWithClass);
    }

    public boolean matchLA(int i, long ... tagsWithClass) {
        TLV lookahead = this.LA(i);
        return this.match(lookahead, tagsWithClass);
    }

    public boolean matchLA(int i, Tag ... tags) {
        TLV lookahead = this.LA(i);
        return this.match(lookahead, this.convertTags(tags));
    }

    private boolean match(TLV tlv, long[] tagsWithClass) {
        if (tlv != null) {
            long tagNumWithClass = tlv.getTagNumWithClass();
            for (long nextTag : tagsWithClass) {
                if (tagNumWithClass != nextTag) continue;
                return true;
            }
        }
        return false;
    }

    private long[] convertTags(Tag ... tags) {
        long[] tagList = new long[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            tagList[i] = tags[i].getTagNumWithClass();
        }
        return tagList;
    }

    public TLV next(int i) {
        if (this.next == null || i < 0) {
            return null;
        }
        TLV nextTLV = this.next;
        for (int count = i; count != 0; --count) {
            if (nextTLV.hasNext()) {
                nextTLV = nextTLV.getNext();
                continue;
            }
            return null;
        }
        this.next = nextTLV.getNext();
        nextTLV = new TLV(nextTLV);
        nextTLV.next = null;
        return nextTLV;
    }

    private TLV LA(int i) {
        if (this.next == null || i < 0) {
            return null;
        }
        TLV nextTLV = this.next;
        for (int count = i; count != 0; --count) {
            if (nextTLV.hasNext()) {
                nextTLV = nextTLV.getNext();
                continue;
            }
            return null;
        }
        nextTLV = new TLV(nextTLV);
        nextTLV.next = null;
        return nextTLV;
    }
}

