/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state.cif;

import iso.std.iso_iec._24727.tech.schema.ApplicationCapabilitiesType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDMarkerType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DSIType;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.DataSetNameListType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.openecard.common.sal.state.cif.CardApplicationWrapper;
import org.openecard.common.sal.state.cif.DIDInfoWrapper;
import org.openecard.common.sal.state.cif.DataSetInfoWrapper;
import org.openecard.common.util.ByteArrayWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardInfoWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CardInfoWrapper.class);
    private final CardInfoType cif;
    private final Map<ByteArrayWrapper, CardApplicationWrapper> cardApplications = new HashMap<ByteArrayWrapper, CardApplicationWrapper>();
    private final List<byte[]> cardApplicationNames = new ArrayList<byte[]>();
    private final String interfaceProtocol;

    public CardInfoWrapper(CardInfoType cif, @Nullable String interfaceProtocol) {
        this.cif = cif;
        this.interfaceProtocol = interfaceProtocol;
        this.filterForProtocol();
    }

    public CardInfoWrapper(CardInfoWrapper other) {
        this(other.cif, other.interfaceProtocol);
    }

    public String getCardType() {
        return this.cif.getCardType().getObjectIdentifier();
    }

    public byte[] getImplicitlySelectedApplication() {
        return this.cif.getApplicationCapabilities().getImplicitlySelectedApplication();
    }

    public ApplicationCapabilitiesType getApplicationCapabilities() {
        return this.cif.getApplicationCapabilities();
    }

    public Map<ByteArrayWrapper, CardApplicationWrapper> getCardApplications() {
        if (this.cardApplications.isEmpty()) {
            for (CardApplicationType cardApplication : this.getApplicationCapabilities().getCardApplication()) {
                this.cardApplications.put(new ByteArrayWrapper(cardApplication.getApplicationIdentifier()), new CardApplicationWrapper(cardApplication));
            }
        }
        return this.cardApplications;
    }

    public DIDInfoType getDIDInfo(String didName, byte[] applicationIdentifier) {
        CardApplicationWrapper application = this.getCardApplications().get(new ByteArrayWrapper(applicationIdentifier));
        if (application == null) {
            return null;
        }
        DIDInfoWrapper didInfo = application.getDIDInfo(didName);
        if (didInfo == null) {
            return null;
        }
        return didInfo.getDIDInfo();
    }

    public DIDInfoType getDIDInfo(String didName, DIDScopeType didScope) {
        List<CardApplicationType> cardApps = this.getApplicationCapabilities().getCardApplication();
        for (CardApplicationType cardApp : cardApps) {
            for (DIDInfoType did : cardApp.getDIDInfo()) {
                if (!did.getDifferentialIdentity().getDIDName().equals(didName)) continue;
                if (did.getDifferentialIdentity().getDIDScope() != null) {
                    if (didScope == null || !didScope.value().equals(did.getDifferentialIdentity().getDIDScope().value())) continue;
                    return did;
                }
                return did;
            }
        }
        return null;
    }

    public DataSetNameListType getDataSetNameList(byte[] cardApplication) {
        CardApplicationWrapper wrapper = this.cardApplications.get(new ByteArrayWrapper(cardApplication));
        if (wrapper == null) {
            return null;
        }
        return wrapper.getDataSetNameList();
    }

    public DataSetInfoType getDataSet(String dataSetName, byte[] applicationIdentifier) {
        CardApplicationWrapper application = this.cardApplications.get(new ByteArrayWrapper(applicationIdentifier));
        if (application == null) {
            return null;
        }
        DataSetInfoWrapper dataSet = application.getDataSetInfo(dataSetName);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getDataSetInfo();
    }

    public CardApplicationWrapper getCardApplication(byte[] applicationIdentifier) {
        return this.getCardApplications().get(new ByteArrayWrapper(applicationIdentifier));
    }

    public DIDStructureType getDIDStructure(String didName, byte[] cardApplication) {
        DIDMarkerType didMarker;
        DIDInfoType didInfo = this.getDIDInfo(didName, cardApplication);
        if (didInfo == null) {
            return null;
        }
        DIDStructureType didStructure = new DIDStructureType();
        didStructure.setDIDName(didInfo.getDifferentialIdentity().getDIDName());
        didStructure.setDIDScope(didInfo.getDifferentialIdentity().getDIDScope());
        if (didStructure.getDIDScope() == null) {
            didStructure.setDIDScope(DIDScopeType.LOCAL);
        }
        if ((didMarker = didInfo.getDifferentialIdentity().getDIDMarker()).getCAMarker() != null) {
            didStructure.setDIDMarker(didMarker.getCAMarker());
        } else if (didMarker.getCryptoMarker() != null) {
            didStructure.setDIDMarker(didMarker.getCryptoMarker());
        } else if (didMarker.getEACMarker() != null) {
            didStructure.setDIDMarker(didMarker.getEACMarker());
        } else if (didMarker.getMutualAuthMarker() != null) {
            didStructure.setDIDMarker(didMarker.getMutualAuthMarker());
        } else if (didMarker.getPACEMarker() != null) {
            didStructure.setDIDMarker(didMarker.getPACEMarker());
        } else if (didMarker.getPinCompareMarker() != null) {
            didStructure.setDIDMarker(didMarker.getPinCompareMarker());
        } else if (didMarker.getRIMarker() != null) {
            didStructure.setDIDMarker(didMarker.getRIMarker());
        } else if (didMarker.getRSAAuthMarker() != null) {
            didStructure.setDIDMarker(didMarker.getRSAAuthMarker());
        } else if (didMarker.getTAMarker() != null) {
            didStructure.setDIDMarker(didMarker.getTAMarker());
        }
        didStructure.setDIDQualifier(didInfo.getDifferentialIdentity().getDIDQualifier());
        return didStructure;
    }

    public DIDStructureType getDIDStructure(String didName, DIDScopeType didScope) {
        DIDMarkerType didMarker;
        DIDInfoType didInfo = this.getDIDInfo(didName, didScope);
        if (didInfo == null) {
            return null;
        }
        DIDStructureType didStructure = new DIDStructureType();
        didStructure.setDIDName(didInfo.getDifferentialIdentity().getDIDName());
        didStructure.setDIDScope(didInfo.getDifferentialIdentity().getDIDScope());
        if (didStructure.getDIDScope() == null) {
            didStructure.setDIDScope(DIDScopeType.LOCAL);
        }
        if ((didMarker = didInfo.getDifferentialIdentity().getDIDMarker()).getCAMarker() != null) {
            didStructure.setDIDMarker(didMarker.getCAMarker());
        } else if (didMarker.getCryptoMarker() != null) {
            didStructure.setDIDMarker(didMarker.getCryptoMarker());
        } else if (didMarker.getEACMarker() != null) {
            didStructure.setDIDMarker(didMarker.getEACMarker());
        } else if (didMarker.getMutualAuthMarker() != null) {
            didStructure.setDIDMarker(didMarker.getMutualAuthMarker());
        } else if (didMarker.getPACEMarker() != null) {
            didStructure.setDIDMarker(didMarker.getPACEMarker());
        } else if (didMarker.getPinCompareMarker() != null) {
            didStructure.setDIDMarker(didMarker.getPinCompareMarker());
        } else if (didMarker.getRIMarker() != null) {
            didStructure.setDIDMarker(didMarker.getRIMarker());
        } else if (didMarker.getRSAAuthMarker() != null) {
            didStructure.setDIDMarker(didMarker.getRSAAuthMarker());
        } else if (didMarker.getTAMarker() != null) {
            didStructure.setDIDMarker(didMarker.getTAMarker());
        }
        didStructure.setDIDQualifier(didInfo.getDifferentialIdentity().getDIDQualifier());
        return didStructure;
    }

    public List<byte[]> getCardApplicationNameList() {
        if (this.cardApplicationNames.isEmpty()) {
            for (CardApplicationType cardApplication : this.getApplicationCapabilities().getCardApplication()) {
                this.cardApplicationNames.add(cardApplication.getApplicationIdentifier());
            }
        }
        return this.cardApplicationNames;
    }

    public DSIType getDSIbyName(String dsiName) {
        for (CardApplicationWrapper cardAppWrapper : this.cardApplications.values()) {
            for (DataSetInfoType dSetInfoWrapper : cardAppWrapper.getDataSetInfoList()) {
                if (dSetInfoWrapper.getDSI() == null) continue;
                for (DSIType dsi : dSetInfoWrapper.getDSI()) {
                    if (!dsi.getDSIName().equals(dsiName)) continue;
                    return dsi;
                }
            }
        }
        return null;
    }

    public DataSetInfoType getDataSetByFid(byte[] fileIdentifier) {
        for (CardApplicationWrapper cardAppWrapper : this.cardApplications.values()) {
            for (DataSetInfoType dSetInfoWrapper : cardAppWrapper.getDataSetInfoList()) {
                int pathLength;
                byte[] dataSetPath = dSetInfoWrapper.getDataSetPath().getEfIdOrPath();
                if (dataSetPath[(pathLength = dataSetPath.length) - 2] != fileIdentifier[0] || dataSetPath[pathLength - 1] != fileIdentifier[1]) continue;
                return dSetInfoWrapper;
            }
        }
        return null;
    }

    public byte[] getApplicationIdByDidName(String didName, DIDScopeType didScope) {
        List<CardApplicationType> cardApps = this.getApplicationCapabilities().getCardApplication();
        for (CardApplicationType cardApp : cardApps) {
            for (DIDInfoType did : cardApp.getDIDInfo()) {
                if (!did.getDifferentialIdentity().getDIDName().equals(didName)) continue;
                if (did.getDifferentialIdentity().getDIDScope() != null) {
                    if (didScope != null) {
                        if (!didScope.value().equals(did.getDifferentialIdentity().getDIDScope().value())) continue;
                        return cardApp.getApplicationIdentifier();
                    }
                    return cardApp.getApplicationIdentifier();
                }
                return cardApp.getApplicationIdentifier();
            }
        }
        return null;
    }

    public DataSetInfoType getDataSetByDsiName(String dsiName) {
        for (CardApplicationWrapper cardAppWrapper : this.cardApplications.values()) {
            for (DataSetInfoType dSetInfoWrapper : cardAppWrapper.getDataSetInfoList()) {
                if (dSetInfoWrapper.getDSI() == null) continue;
                for (DSIType dsi : dSetInfoWrapper.getDSI()) {
                    if (!dsi.getDSIName().equals(dsiName)) continue;
                    return dSetInfoWrapper;
                }
            }
        }
        return null;
    }

    public DataSetInfoType getDataSetByName(String dataSetName) {
        for (CardApplicationWrapper cardAppWrapper : this.cardApplications.values()) {
            for (DataSetInfoType dSetInfoWrapper : cardAppWrapper.getDataSetInfoList()) {
                if (!dSetInfoWrapper.getDataSetName().equals(dataSetName)) continue;
                return dSetInfoWrapper;
            }
        }
        return null;
    }

    private void filterForProtocol() {
        List<CardApplicationType> apps = this.getApplicationCapabilities().getCardApplication();
        Iterator<CardApplicationType> it = apps.iterator();
        while (it.hasNext()) {
            CardApplicationType app = it.next();
            List<String> interfaceProtos = app.getInterfaceProtocol();
            if (interfaceProtos.isEmpty()) continue;
            if (this.interfaceProtocol == null) {
                String msg = "Interface protocol is not available.";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
            if (interfaceProtos.contains(this.interfaceProtocol)) continue;
            it.remove();
        }
    }
}

