/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.ifd.anytype;

import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.util.ByteUtils;

public class PACEOutputType {
    public static final String RETRY_COUNTER = "RetryCounter";
    public static final String EF_CARD_ACCESS = "EFCardAccess";
    public static final String CURRENT_CAR = "CARcurr";
    public static final String PREVIOUS_CAR = "CARprev";
    public static final String ID_PICC = "IDPICC";
    private final AuthDataMap authMap;
    private byte[] efCardAccess;
    private byte[] currentCAR;
    private byte[] previousCAR;
    private byte[] idpicc;
    private byte retryCounter;

    protected PACEOutputType(AuthDataMap authMap) {
        this.authMap = authMap;
    }

    public void setEFCardAccess(byte[] efCardAccess) {
        this.efCardAccess = efCardAccess;
    }

    public void setCurrentCAR(byte[] car) {
        this.currentCAR = car;
    }

    public void setPreviousCAR(byte[] car) {
        this.previousCAR = car;
    }

    public void setIDPICC(byte[] idpicc) {
        this.idpicc = idpicc;
    }

    public void setRetryCounter(byte counter) {
        this.retryCounter = counter;
    }

    public iso.std.iso_iec._24727.tech.schema.PACEOutputType getAuthDataType() {
        AuthDataResponse<iso.std.iso_iec._24727.tech.schema.PACEOutputType> authResponse = this.authMap.createResponse(new iso.std.iso_iec._24727.tech.schema.PACEOutputType());
        authResponse.addElement(RETRY_COUNTER, String.valueOf(this.retryCounter));
        authResponse.addElement(EF_CARD_ACCESS, ByteUtils.toHexString(this.efCardAccess));
        if (this.currentCAR != null) {
            authResponse.addElement(CURRENT_CAR, ByteUtils.toHexString(this.currentCAR));
        }
        if (this.previousCAR != null) {
            authResponse.addElement(PREVIOUS_CAR, ByteUtils.toHexString(this.previousCAR));
        }
        if (this.idpicc != null) {
            authResponse.addElement(ID_PICC, ByteUtils.toHexString(this.idpicc));
        }
        return authResponse.getResponse();
    }
}

