/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.event;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.RequestType;
import iso.std.iso_iec._24727.tech.schema.ResponseType;
import javax.annotation.Nonnull;
import org.openecard.common.event.EventObject;
import org.openecard.common.util.JAXBUtils;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshallerException;

public class ApiCallEventObject<Request extends RequestType, Response extends ResponseType>
extends EventObject {
    protected final Request req;
    protected Response res;

    public ApiCallEventObject(ConnectionHandleType handle, Request req) {
        super(handle);
        this.req = (RequestType)this.copyMessage(req);
    }

    @Nonnull
    private <T> T copyMessage(@Nonnull T msg) {
        try {
            return JAXBUtils.deepCopy(msg);
        }
        catch (MarshallingTypeException ex) {
            throw new RuntimeException("The requested type is not supported by the marshaller.", ex);
        }
        catch (WSMarshallerException ex) {
            throw new RuntimeException("Error initializing the marshaller.", ex);
        }
    }

    public void setResponse(@Nonnull Response res) {
        this.res = (ResponseType)this.copyMessage(res);
    }

    public Request getRequest() {
        return this.req;
    }

    public Response getResponse() {
        return this.res;
    }

    public boolean hasResponse() {
        return this.getResponse() != null;
    }
}

