/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu;

import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.util.ByteUtils;

public class ResetRetryCounter
extends CardCommandAPDU {
    private static final byte RESET_RETRY_COUNTER_INS = 44;

    public ResetRetryCounter(byte[] password, byte type) {
        super((byte)0, (byte)44, (byte)2, type);
        this.setData(password);
    }

    public ResetRetryCounter(byte type) {
        super((byte)0, (byte)44, (byte)3, type);
    }

    public ResetRetryCounter(byte[] resettingCode, byte[] newRefData, byte type) {
        super((byte)0, (byte)44, (byte)0, type);
        this.setData(ByteUtils.concatenate(resettingCode, newRefData));
    }

    public boolean isWithNewPin() {
        return this.getP1() == 2;
    }

    public boolean isDataAbsent() {
        return this.getP1() == 3;
    }

    public boolean isWithPukAndNewPin() {
        return this.getP1() == 0;
    }

    public boolean isWithPuk() {
        return this.getP1() == 1;
    }
}

