/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.anytype.pin;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.PinCompareDIDAuthenticateInputType;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.anytype.pin.PINCompareDIDAuthenticateOutputType;

public class PINCompareDIDAuthenticateInputType {
    private static final String ISO_NS = "urn:iso:std:iso-iec:24727:tech:schema";
    private final AuthDataMap authMap;
    private char[] pin;

    public PINCompareDIDAuthenticateInputType(DIDAuthenticationDataType data) throws ParserConfigurationException {
        this.authMap = new AuthDataMap(data);
        String tmpPin = this.authMap.getContentAsString("Pin");
        this.pin = tmpPin != null ? tmpPin.toCharArray() : new char[0];
    }

    public char[] getPIN() {
        return (char[])this.pin.clone();
    }

    public void setPIN(char[] pin) {
        if (this.pin != null) {
            Arrays.fill(this.pin, ' ');
        }
        this.pin = (char[])(pin != null ? (char[])pin.clone() : null);
    }

    public PINCompareDIDAuthenticateOutputType getOutputType() {
        return new PINCompareDIDAuthenticateOutputType(this.authMap);
    }

    public PinCompareDIDAuthenticateInputType getAuthDataType() {
        PinCompareDIDAuthenticateInputType pinCompareOutput = new PinCompareDIDAuthenticateInputType();
        AuthDataResponse<PinCompareDIDAuthenticateInputType> authResponse = this.authMap.createResponse(pinCompareOutput);
        if (this.pin != null) {
            authResponse.addElement(ISO_NS, "Pin", new String(this.pin));
        }
        return authResponse.getResponse();
    }
}

