/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import java.util.List;
import javax.annotation.Nonnull;
import oasis.names.tc.dss._1_0.core.schema.InternationalStringType;
import oasis.names.tc.dss._1_0.core.schema.ResponseBaseType;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.ECardException;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.util.HandlerUtils;

public class WSHelper {
    public static <T extends ResponseBaseType> T checkResult(@Nonnull T response) throws WSException {
        Result r = response.getResult();
        if (r.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
            if (response instanceof TransmitResponse) {
                TransmitResponse tr = (TransmitResponse)response;
                List<byte[]> rApdus = tr.getOutputAPDU();
                if (rApdus.size() < 1) {
                    throw new WSException(r);
                }
                byte[] apdu = CardResponseAPDU.getTrailer(rApdus.get(rApdus.size() - 1));
                String msg = CardCommandStatus.getMessage(apdu);
                throw new WSException(msg);
            }
            throw new WSException(r);
        }
        return response;
    }

    public static <T extends ResponseBaseType> boolean resultsInWarn(@Nonnull T response) throws WSException {
        Result r = response.getResult();
        return r.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#warning");
    }

    public static WSException createException(@Nonnull Result r) {
        return new WSException(r);
    }

    public static Result makeResultOK() {
        Result result = WSHelper.makeResult("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok", null, null, null);
        return result;
    }

    public static Result makeResultUnknownError(String msg) {
        Result result = WSHelper.makeResult("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError", msg);
        return result;
    }

    public static Result makeResult(String major, String minor, String message) {
        Result result = WSHelper.makeResult(major, minor, message, "en");
        return result;
    }

    public static Result makeResultError(String minor, String message) {
        Result result = WSHelper.makeResult("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", minor, message, "en");
        return result;
    }

    public static Result makeResult(Throwable exc) {
        if (exc instanceof ECardException) {
            ECardException e = (ECardException)exc;
            Result result = e.getResult();
            return result;
        }
        Result result = WSHelper.makeResultUnknownError(exc.getMessage());
        return result;
    }

    public static Result makeResult(String major, String minor, String message, String lang) {
        Result r = new Result();
        r.setResultMajor(major);
        r.setResultMinor(minor);
        if (message != null) {
            InternationalStringType msg = new InternationalStringType();
            msg.setValue(message);
            msg.setLang(lang);
            r.setResultMessage(msg);
        }
        return r;
    }

    public static <C extends Class<T>, T extends ResponseBaseType> T makeResponse(C c, Result r) {
        try {
            ResponseBaseType t = (ResponseBaseType)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            t.setProfile("http://www.bsi.bund.de/ecard/api/1.1");
            t.setResult(r);
            return (T)t;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Deprecated
    public static ConnectionHandleType copyHandle(ConnectionHandleType handle) {
        return HandlerUtils.copyHandle(handle);
    }

    @Deprecated
    public static CardApplicationPathType copyPath(CardApplicationPathType handle) {
        return HandlerUtils.copyPath(handle);
    }

    public static class WSException
    extends ECardException {
        private static final long serialVersionUID = 1L;

        protected WSException(Result r) {
            WSException.makeException(this, r);
        }

        protected WSException(String msg) {
            WSException.makeException(this, msg);
        }
    }
}

