/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.openecard.common.util.FileUtils;
import org.openecard.ws.common.OverridingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenecardProperties {
    private static final Logger _logger = LoggerFactory.getLogger(OpenecardProperties.class);
    private static OverridingProperties properties;

    public static synchronized void load() {
        InputStream homeProps = OpenecardProperties.loadHomeProps();
        InputStream bundledProps = null;
        try {
            String fileName = "openecard_config/openecard.properties";
            bundledProps = FileUtils.resolveResourceAsStream(OpenecardProperties.class, fileName);
        }
        catch (IOException ex) {
            _logger.info("Failed to load properties from config dir.", ex);
        }
        try {
            properties = new OverridingProperties(bundledProps, homeProps);
        }
        catch (IOException ex) {
            _logger.error(ex.getMessage(), ex);
        }
    }

    private static InputStream loadHomeProps() {
        try {
            File homePath = FileUtils.getHomeConfigDir();
            File cfgFile = new File(homePath, "openecard.properties");
            FileInputStream homeProps = new FileInputStream(cfgFile);
            return homeProps;
        }
        catch (IOException ex) {
            _logger.info("Failed to load bundled properties.", ex);
            return null;
        }
    }

    private static void saveHomeProps(Properties homeProps) throws IOException {
        File homePath = FileUtils.getHomeConfigDir();
        File cfgFile = new File(homePath, "openecard.properties");
        FileOutputStream out = new FileOutputStream(cfgFile);
        homeProps.store(out, null);
        ((OutputStream)out).close();
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static Properties properties() {
        return properties.properties();
    }

    public static synchronized void writeChanges(Properties changes) throws IOException {
        Properties homeProps = new Properties();
        InputStream homeStream = OpenecardProperties.loadHomeProps();
        if (homeStream != null) {
            homeProps.load(homeStream);
            homeStream.close();
        }
        for (Map.Entry<Object, Object> next : changes.entrySet()) {
            homeProps.put(next.getKey(), next.getValue());
        }
        OpenecardProperties.saveHomeProps(homeProps);
    }

    static {
        OpenecardProperties.load();
    }
}

