/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import org.openecard.common.I18n;
import org.openecard.common.I18nKey;

public abstract class I18nException
extends Exception {
    private final String localMsg;

    public I18nException(String message) {
        super(message);
        this.localMsg = null;
    }

    public I18nException(Throwable cause) {
        super(cause);
        this.localMsg = cause.getLocalizedMessage();
    }

    public I18nException(String message, Throwable cause) {
        super(cause);
        this.localMsg = null;
    }

    public I18nException(I18n lang, String key, Object ... params) {
        super(lang.getOriginalMessage(key, params));
        this.localMsg = lang.translationForKey(key, params);
    }

    public I18nException(I18n lang, String key, Throwable cause, Object ... params) {
        super(lang.getOriginalMessage(key, params), cause);
        this.localMsg = lang.translationForKey(key, params);
    }

    public I18nException(I18n lang, I18nKey key, Object ... params) {
        super(lang.getOriginalMessage(key, params));
        this.localMsg = lang.translationForKey(key, params);
    }

    public I18nException(I18n lang, I18nKey key, Throwable cause, Object ... params) {
        super(lang.getOriginalMessage(key, params), cause);
        this.localMsg = lang.translationForKey(key, params);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.localMsg != null) {
            return this.localMsg;
        }
        return super.getLocalizedMessage();
    }
}

