/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.math.BigInteger;
import java.util.TreeMap;

public class ECardConstants {
    private static final String ECARD_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/";
    private static final String MAJOR_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#";
    private static final String DSS_PREFIX = "urn:oasis:names:tc:dss:1.0:";
    private static final String MINOR_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/";
    public static final int CONTEXT_HANDLE_DEFAULT_SIZE = 16;
    public static final int SLOT_HANDLE_DEFAULT_SIZE = 24;
    public static final String UNKNOWN_CARD = "http://bsi.bund.de/cif/unknown";
    public static final String PAOS_NEXT = "http://www.bsi.bund.de/ecard/api/1.1/PAOS/GetNextCommand";
    public static final String ACTOR_NEXT = "http://schemas.xmlsoap.org/soap/actor/next";
    public static final String SOAP_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String PAOS_VERSION_11 = "urn:liberty:paos:2003-08";
    public static final String PAOS_VERSION_20 = "urn:liberty:paos:2006-08";
    public static final String WS_ADDRESSING = "http://www.w3.org/2005/03/addressing";
    public static final BigInteger ECARD_API_VERSION_MAJOR = BigInteger.valueOf(1L);
    public static final BigInteger ECARD_API_VERSION_MINOR = BigInteger.valueOf(1L);
    public static final BigInteger ECARD_API_VERSION_SUBMINOR = BigInteger.valueOf(4L);
    private static final TreeMap<String, String> msgMap = new TreeMap();

    @Deprecated
    public static String URI2Msg(String uri) {
        String result = msgMap.get(uri);
        return result != null ? result : "";
    }

    static {
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok", "No error occurred during execution of the operation.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#warning", "If the result of the operation is in principle OK, but there is a detail which may require closer investigation, a warning is given as a response.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", "An error occurred during execution of the operation.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#nextRequest", "This result appears if at least one more request is expected within a protocol.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#noPermission", "Use of the function by the client application is not permitted.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", "Internal error.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#parameterError", "There was some problem with a provided or omitted parameter.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownConnectionHandle", "Unknown connection handle specified.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownCardType", "Unknown card type specified.");
        msgMap.put("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/support#cardInfoRepositoryUnreachable", "The CardInfo repository server is not accessible");
    }

    public static class Minor {

        public static class IFD {
            private static final String IFD_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl";
            private static final String IO_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#";
            private static final String TERM_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#";
            public static final String TIMEOUT_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError";
            public static final String INVALID_CONTEXT_HANDLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle";
            public static final String CANCELLATION_BY_USER = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser";
            public static final String UNKNOWN_SESSION = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#unkownSessionIdentifier";
            public static final String INVALID_SLOT_HANDLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle";
            public static final String PASSWORD_SUSPENDED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordSuspended";
            public static final String PASSWORD_BLOCKED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordBlocked";
            public static final String PASSWORD_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordError";
            public static final String PASSWORD_DEACTIVATED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordDeactivated";
            public static final String AUTHENTICATION_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/authenticationFailed";
            public static final String PASSWORDS_DONT_MATCH = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordDontMatch";
            public static final String UNKNOWN_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/unknownError";

            public static class Terminal {
                public static final String UNKNOWN_IFD = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD";
                public static final String NO_CARD = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#noCard";
                public static final String IFD_SHARING_VIOLATION = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#IFDSharingViolation";
                public static final String UNKNOWN_ACTION = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownAction";
                public static final String UNKNOWN_SLOT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownSlot";
                public static final String ACCESS_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#accessError";
            }

            public static class IO {
                public static final String UNKNOWN_INPUT_UNIT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownInputUnit";
                public static final String UNKNOWN_DISPLAY_INDEX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownDisplayIndex";
                public static final String CANCEL_NOT_POSSIBLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#cancelNotPossible";
                public static final String NO_TRANSACTION_STARTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdlnoTransactionStarted";
                public static final String REPEATED_DATA_MISMATCH = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdlrepeatedDataMismatch";
                public static final String UNKNOWN_PIN_FORMAT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownPINFormat";
                public static final String UNKNOWN_OUTPUT_DEVICE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownOutputDevice";
                public static final String UNKNOWN_BIOMETRIC_TYPE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownBiometricSubtype";
            }
        }

        public static class SAL {
            private static final String SAL_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal";
            private static final String SUPPORT_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/support#";
            private static final String EAC_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/mEAC#";
            public static final String CANCELLATION_BY_USER = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#cancellationByUser";
            public static final String NAME_EXISTS = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#nameExists";
            public static final String PREREQUISITES_NOT_SATISFIED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#prerequisitesNotSatisfied";
            public static final String PROTOCOL_NOT_RECOGNIZED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#protocolNotRecognized";
            public static final String INAPPROPRIATE_PROTOCOL_FOR_ACTION = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#inappropriateProtocolForAction";
            public static final String INVALID_SIGNATURE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#invalidSignature";
            public static final String INVALID_KEY = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#invalidKey";
            public static final String NOT_INITIALIZED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#notInitialized";
            public static final String TOO_MANY_RESULTS = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#tooManyResults";
            public static final String WARN_CONNECTION_DISCONNECT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#warningConnectionDisconnected";
            public static final String WARN_SESSION_END = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#warningSessionEnded";
            public static final String NAMED_ENTITY_NOT_FOUND = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#namedEntityNotFound";
            public static final String INSUFFICIENT_RES = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#insufficientResources";
            public static final String SECURITY_CONDITION_NOT_SATISFIED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#securityConditionNotSatisfied";
            public static final String EXCLUSIVE_NA = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#exclusiveNotAvailable";
            public static final String NO_SESSION = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#noActiveSession";
            public static final String DEC_NOT_POSSIBLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#decryptionNotPossible";
            public static final String INVALID_ACL = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#invalidAccessControlInformation";
            public static final String UNKOWN_PROTOCOL = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownProtocol";
            public static final String UNKNOWN_CARDTYPE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownCardType";
            public static final String UNKOWN_DID_NAME = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownDIDName";
            public static final String FILE_NOT_FOUND = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#fileNotFound";
            public static final String UNKNOWN_HANDLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownConnectionHandle";

            public static class EAC {
                public static final String AGE_VERIF_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/mEAC#AgeVerificationFailedWarning";
                public static final String COMMUNITY_VERIF_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/mEAC#CommunityVerificationFailedWarning";
                public static final String DOC_VALID_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/mEAC#DocumentValidityVerificationFailed";
            }

            public static class Support {
                public static final String ENCODING_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/support#encodingError";
                public static final String DECODING_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/support#decodingError";
                public static final String SCHEMA_VAILD_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/support#schemaValidationError";
                public static final String SCHEMA_VAILD_WARN = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/support#schemaValidationWarning";
                public static final String NO_SCHEMA = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/support#noAppropriateSchema";
                public static final String REPO_UNREACHABLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/support#cardInfoRepositoryUnreachable";
            }
        }

        public static class Ident {
            private static final String IL_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il";
            private static final String ALG_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/algorithm#";
            private static final String CR_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/certificateRequest#";
            private static final String ENC_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/encryption#";
            private static final String KEY_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/key#";
            private static final String SERVICE_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/service#";
            private static final String SIG_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#";
            private static final String VIEW_PFX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/viewer#";

            public static class Viewer {
                public static final String UNSUITABLE_SS = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/viewer#unsuitableStylesheetForDocument";
                public static final String USER_CANCEL = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/viewer#cancelationByUser";
                public static final String TIMEOUT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/viewer#timeout";
                public static final String MSG_TOO_LONG = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/viewer#viewerMessageTooLong";
            }

            public static class Signature {
                public static final String FORMAT_NOT_SUPPORTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#signatureFormatNotSupported";
                public static final String SIG_NON_PDFDOC = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#PDFSignatureForNonPDFDocument";
                public static final String INCLUDE_ECONTENT_NOT_POSSIBLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#unableToIncludeEContentWarning";
                public static final String IGNORE_SIG_PLACEMENT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#ignoredSignaturePlacementFlagWarning";
                public static final String CERT_NOT_FOUND = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#certificateNotFound";
                public static final String WRONG_CERT_FORMAT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#certificateFormatNotCorrect";
                public static final String INVALID_CERT_REF = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#invalidCertificateReference";
                public static final String CHAIN_INTERRUPTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#certificateChainInterrupted";
                public static final String OBJREF_UNRESOLVEABLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#resolutionOfObjectReferenceImpossible";
                public static final String TRANSFORM_NOT_SUPPORTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#transformationAlgorithmNotSupported";
                public static final String UNKNOWN_VIEWER = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#unknownViewer";
                public static final String CERT_PATH_NOT_VALIDATED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#certificatePathNotValidated";
                public static final String CERT_STATUS_NOT_CHECKED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#certificateStatusNotChecked";
                public static final String SIG_MANIFEST_NOT_CHECKED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#signatureManifestNotCheckedWarning";
                public static final String ALGS_NOT_CHECKED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#suitabilityOfAlgorithmsNotChecked";
                public static final String DETACHED_NO_CONTENT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#detachedSignatureWithoutEContent";
                public static final String WRONG_REVOCATION_INFO = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#improperRevocationInformation";
                public static final String INVALID_SIG_FORMAT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#invalidSignatureFormat";
                public static final String SIGALG_NOT_SUITABLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#signatureAlgorithmNotSuitable";
                public static final String HASHALG_NOT_SUITABLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#hashAlgorithmNotSuitable";
                public static final String CERT_PATH_INVALID = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#invalidCertificatePath";
                public static final String CERT_REVOKED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#certificateRevoked";
                public static final String CERT_EXPIRED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#referenceTimeNotWithinCertificateValidityPeriod";
                public static final String INVALID_CERT_EXT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#invalidCertificateExtension";
                public static final String SIG_MANIFEST_WRONG = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#signatureManifestNotCorrect";
                public static final String SIG_NOT_SUPPORT_FORM_CLARIFICATION = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#signatureTypeDoesNotSupportSignatureFormClarificationWarning";
                public static final String UNKNOWN_SIG_FORM = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#unknownSignatureForm";
                public static final String INCLUDE_ONLY_XML = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#includeObjectOnlyForXMLSignatureAllowedWarning";
                public static final String XPATH_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#xPathEvaluationError";
                public static final String WRONG_MSG_DIGEST = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#wrongMessageDigest";
                public static final String IFD_INCONSISTENCY = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/signature#IFDInconsistency";
            }

            public static class Service {
                public static final String OCSP_UNREACHABLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/service#ocspResponderUnreachable";
                public static final String DIR_UNREACHABLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/service#directoryServiceUnreachable";
                public static final String TS_UNREACHABLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/service#timeStampServiceUnreachable";
            }

            public static class Key {
                public static final String KEYGEN_NOT_POSSIBLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/key#keyGenerationNotPossible";
                public static final String ENC_ALG_NOT_SUPPORTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/key#encryptionAlgorithmNotSupported";
            }

            public static class Encryption {
                public static final String NODES_ENC = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/encryption#encryptionOfCertainNodesOnlyForXMLDocuments";
                public static final String FORMAT_NOT_SUPPORTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/encryption#encryptionFormatNotSupported";
                public static final String INVALID_CERT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/encryption#invalidCertificate";
            }

            public static class CertificateRequest {
                public static final String UNKNOWN_ATTR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/certificateRequest#unknownAttribute";
                public static final String CREATION_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/certificateRequest#creationOfCertificateRequestFailed";
                public static final String SUBMISSION_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/certificateRequest#submissionFailed";
                public static final String UNKOWN_TRANSACTION = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/certificateRequest#unknownTransactionID";
                public static final String DOWNLOAD_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/certificateRequest#certificateDownloadFailed";
                public static final String SUBJECT_MISSING = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/certificateRequest#subjectMissing";
            }

            public static class Algorithm {
                public static final String HASH_NOT_SUPPORTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/algorithm#hashAlgorithmNotSupported";
                public static final String SIG_NOT_SUPPORTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/il/algorithm#signatureAlgorithmNotSupported";
            }
        }

        public static class Disp {
            private static final String DP_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp";
            public static final String TIMEOUT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#timeoutError";
            public static final String UNKNOWN_CHANNEL_HANDLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#unknownChannelHandle";
            public static final String COMM_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#communicationError";
            public static final String CHANNEL_ESTABLISHMENT_FAILED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#trustedChannelEstablishmentFailed";
            public static final String UNKOWN_PROTOCOL = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#unknownProtocol";
            public static final String UNKNOWN_CIPHER = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#unknownCipherSuite";
            public static final String UNKNOWN_BINDING = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#unknownWebserviceBinding";
            public static final String NODE_NOT_REACHABLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#nodeNotReachable";
            public static final String INVALID_CHANNEL_HANDLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#invalidChannelHandle";
        }

        public static class App {
            private static final String APP_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al";
            private static final String APP_CIF_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/CardInfo#";
            private static final String APP_FW_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/FrameworkUpdate#";
            private static final String APP_IFD_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/IFD#";
            private static final String APP_TV_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/TrustedViewer#";
            private static final String APP_TSL_PREFIX = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/TSL#";
            public static final String UNKNOWN_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError";
            public static final String NO_PERM = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#noPermission";
            public static final String INT_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError";
            public static final String PARM_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#parameterError";
            public static final String UNKNOWN_API = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownAPIFunction";
            public static final String NOT_INITIALIZED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#notInitialized";
            public static final String CON_DISCONNECT = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#warningConnectionDisconnected";
            public static final String SESS_TERMINATED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#SessionTerminatedWarning";
            public static final String INCORRECT_PARM = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter";
            public static final String COMMUNICATION_ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#communicationError";

            public static class TSL {
                public static final String SEQNUM_IGNORED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/TSL#TSLSequenceNumberIgnoredWarning";
            }

            public static class Viewer {
                public static final String DEL_IMPOSS = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/TrustedViewer#deleteNotPossible";
                public static final String INVALID_ID = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/TrustedViewer#invalidID";
                public static final String INVALID_CONF = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/TrustedViewer#invalidConfiguration";
                public static final String EXISTING = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/TrustedViewer#alreadyExisting";
            }

            public static class IFD {
                public static final String WRITE_CONF_IMPOSS = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/IFD#writeConfigurationNotPossible";
                public static final String COULD_NOT_ADD = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/IFD#couldNotAdd";
                public static final String DEL_IMPOSS = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/IFD#deleteNotPossible";
                public static final String ADD_IMPOSS = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/IFD#addNotPossible";
            }

            public static class FW {
                public static final String SERVICE_NA = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/FrameworkUpdate#serviceNotAvailable";
                public static final String UNKNOWN_MODULE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/FrameworkUpdate#unknownModule";
                public static final String INVALID_VERSION = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/FrameworkUpdate#invalidVersionNumber";
                public static final String OS_NOT_SUPPORTED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/FrameworkUpdate#operationSystemNotSupported";
                public static final String NO_SPACE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/FrameworkUpdate#noSpaceAvailable";
                public static final String SEC_NOT_SATISFIED = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/FrameworkUpdate#securityConditionsNotSatisfied";
            }

            public static class CIF {
                public static final String ADD_NOT_POSSIBLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/CardInfo#addNotPossible";
                public static final String NOT_EXISTING = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/CardInfo#notExisting";
                public static final String DEL_NOT_POSSIBLE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/CardInfo#deleteNotPossible";
                public static final String ALREADY_EXISTING = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/CardInfo#alreadyExisting";
                public static final String INCORRECT_FILE = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/CardInfo#incorrectFile";
            }
        }
    }

    public static class Major {
        public static final String OK = "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok";
        public static final String PENDING = "urn:oasis:names:tc:dss:1.0:profiles:asynchronousprocessing:resultmajor:Pending";
        public static final String WARN = "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#warning";
        public static final String ERROR = "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error";
        public static final String NEXT = "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#nextRequest";
    }

    public static class IFD {

        public static class Protocol {
            public static final String T0 = "urn:iso:std:iso-iec:7816:-3:tech:protocols:T-equals-0";
            public static final String T1 = "urn:iso:std:iso-iec:7816:-3:tech:protocols:T-equals-1";
            public static final String T2 = "urn:iso:std:iso-iec:10536:tech:protocols:T-equals-2";
            public static final String TYPE_A = "urn:iso:std:iso-iec:14443:-2:tech:protocols:Type-A";
            public static final String TYPE_B = "urn:iso:std:iso-iec:14443:-2:tech:protocols:Type-B";
        }
    }

    public static class Protocol {
        public static final String PIN_COMPARE = "urn:oid:1.3.162.15480.3.0.9";
        public static final String MUTUAL_AUTH = "urn:oid:1.3.162.15480.3.0.12";
        public static final String EAC_GENERIC = "urn:oid:1.3.162.15480.3.0.14";
        public static final String EAC2 = "urn:oid:1.3.162.15480.3.0.14.2";
        public static final String RSA_AUTH = "urn:oid:1.3.162.15480.3.0.15";
        public static final String GENERIC_CRYPTO = "urn:oid:1.3.162.15480.3.0.25";
        public static final String TERMINAL_AUTH = "urn:oid:0.4.0.127.0.7.2.2.2";
        public static final String CHIP_AUTH = "urn:oid:0.4.0.127.0.7.2.2.3";
        public static final String PACE = "urn:oid:0.4.0.127.0.7.2.2.4";
        public static final String RESTRICTED_ID = "urn:oid:0.4.0.127.0.7.2.2.5";
    }

    public static class Profile {
        public static final String ECARD_1_1 = "http://www.bsi.bund.de/ecard/api/1.1";
    }

    public static class CIF {
        public static final String GET_SPECIFIED = "http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getSpecifiedFile";
        public static final String GET_RELATED = "http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getRelatedFiles";
        public static final String GET_OTHER = "http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getOtherFiles";
    }
}

