/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.util.Promise;

public class DynamicContext {
    private static final InheritableThreadLocal<Map<String, DynamicContext>> localMap = new InheritableThreadLocal<Map<String, DynamicContext>>(){

        @Override
        protected Map<String, DynamicContext> initialValue() {
            return new ConcurrentSkipListMap<String, DynamicContext>();
        }

        @Override
        protected Map<String, DynamicContext> childValue(Map<String, DynamicContext> parentValue) {
            return parentValue;
        }
    };
    private final Map<String, Promise<Object>> context = new HashMap<String, Promise<Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static DynamicContext getInstance(@Nonnull String key) {
        Map local;
        Map map = local = (Map)localMap.get();
        synchronized (map) {
            DynamicContext inst;
            if (local.containsKey(key)) {
                inst = (DynamicContext)local.get(key);
            } else {
                inst = new DynamicContext();
                local.put(key, inst);
            }
            return inst;
        }
    }

    public static void remove() {
        localMap.remove();
    }

    private DynamicContext() {
    }

    @Nonnull
    public synchronized Promise<Object> getPromise(@Nonnull String key) {
        Promise<Object> p = this.context.get(key);
        if (p != null) {
            return p;
        }
        p = new Promise();
        this.context.put(key, p);
        return p;
    }

    @Nullable
    public Object get(@Nonnull String key) {
        Promise<Object> p = this.getPromise(key);
        return p.derefNonblocking();
    }

    @Nullable
    public synchronized Object put(@Nonnull String key, @Nullable Object value) {
        Promise<Object> p = this.getPromise(key);
        if (p.isDelivered()) {
            this.remove(key);
            p = this.getPromise(key);
        }
        p.deliver(value);
        return value;
    }

    public synchronized void putPromise(@Nonnull String key, @Nonnull Promise p) {
        if (this.context.get(key) != null) {
            throw new IllegalStateException("Promise already exists and can therefore not be delivered anymore.");
        }
        this.context.put(key, p);
    }

    @Nullable
    public Object remove(@Nonnull String key) {
        Promise<Object> p = this.context.remove(key);
        if (p != null) {
            return p.derefNonblocking();
        }
        return null;
    }

    public void clear() {
        this.context.clear();
    }
}

