/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tsp.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openecard.bouncycastle.asn1.BEROctetString;
import org.openecard.bouncycastle.asn1.DERIA5String;
import org.openecard.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.openecard.bouncycastle.asn1.cms.ContentInfo;
import org.openecard.bouncycastle.asn1.cms.Evidence;
import org.openecard.bouncycastle.asn1.cms.TimeStampAndCRL;
import org.openecard.bouncycastle.asn1.cms.TimeStampTokenEvidence;
import org.openecard.bouncycastle.asn1.cms.TimeStampedData;
import org.openecard.bouncycastle.cms.CMSException;
import org.openecard.bouncycastle.tsp.TimeStampToken;
import org.openecard.bouncycastle.tsp.cms.CMSTimeStampedData;
import org.openecard.bouncycastle.tsp.cms.CMSTimeStampedGenerator;
import org.openecard.bouncycastle.util.io.Streams;

public class CMSTimeStampedDataGenerator
extends CMSTimeStampedGenerator {
    public CMSTimeStampedData generate(TimeStampToken timeStamp) throws CMSException {
        return this.generate(timeStamp, (InputStream)null);
    }

    public CMSTimeStampedData generate(TimeStampToken timeStamp, byte[] content) throws CMSException {
        return this.generate(timeStamp, new ByteArrayInputStream(content));
    }

    public CMSTimeStampedData generate(TimeStampToken timeStamp, InputStream content) throws CMSException {
        ByteArrayOutputStream contentOut = new ByteArrayOutputStream();
        if (content != null) {
            try {
                Streams.pipeAll(content, contentOut);
            }
            catch (IOException e) {
                throw new CMSException("exception encapsulating content: " + e.getMessage(), e);
            }
        }
        BEROctetString encContent = null;
        if (contentOut.size() != 0) {
            encContent = new BEROctetString(contentOut.toByteArray());
        }
        TimeStampAndCRL stamp = new TimeStampAndCRL(timeStamp.toCMSSignedData().toASN1Structure());
        DERIA5String asn1DataUri = null;
        if (this.dataUri != null) {
            asn1DataUri = new DERIA5String(this.dataUri.toString());
        }
        return new CMSTimeStampedData(new ContentInfo(CMSObjectIdentifiers.timestampedData, new TimeStampedData(asn1DataUri, this.metaData, encContent, new Evidence(new TimeStampTokenEvidence(stamp)))));
    }
}

