/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls.crypto.impl.bc;

import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.RSAKeyParameters;
import org.openecard.bouncycastle.tls.Certificate;
import org.openecard.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.openecard.bouncycastle.tls.crypto.TlsSigner;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey) {
        BcTlsSigner signer;
        if (privateKey instanceof RSAKeyParameters) {
            signer = new BcTlsRSASigner(crypto, (RSAKeyParameters)privateKey);
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            signer = new BcTlsDSASigner(crypto, (DSAPrivateKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            signer = new BcTlsECDSASigner(crypto, (ECPrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey), certificate, signatureAndHashAlgorithm);
    }
}

