/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.openecard.bouncycastle.tls.AbstractTlsKeyExchange;
import org.openecard.bouncycastle.tls.Certificate;
import org.openecard.bouncycastle.tls.CertificateRequest;
import org.openecard.bouncycastle.tls.TlsCredentialedDecryptor;
import org.openecard.bouncycastle.tls.TlsCredentialedSigner;
import org.openecard.bouncycastle.tls.TlsCredentials;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsRSAUtils;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.TlsCertificate;
import org.openecard.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.openecard.bouncycastle.tls.crypto.TlsSecret;

public class TlsRSAKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsSecret preMasterSecret;

    public TlsRSAKeyExchange(Vector supportedSignatureAlgorithms) {
        super(1, supportedSignatureAlgorithms);
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedDecryptor)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.serverCertificate = serverCertificate.getCertificateAt(0).useInRole(0, this.keyExchange);
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate, output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readOpaque16(input);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tmp = this.preMasterSecret;
        this.preMasterSecret = null;
        return tmp;
    }
}

