/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.InputStream;
import org.openecard.bouncycastle.tls.ByteQueue;

public class ByteQueueInputStream
extends InputStream {
    private ByteQueue buffer = new ByteQueue();

    public void addBytes(byte[] bytes) {
        this.buffer.addData(bytes, 0, bytes.length);
    }

    public int peek(byte[] buf) {
        int bytesToRead = Math.min(this.buffer.available(), buf.length);
        this.buffer.read(buf, 0, bytesToRead, 0);
        return bytesToRead;
    }

    @Override
    public int read() {
        if (this.buffer.available() == 0) {
            return -1;
        }
        return this.buffer.removeData(1, 0)[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int bytesToRead = Math.min(this.buffer.available(), len);
        this.buffer.removeData(b, off, bytesToRead, 0);
        return bytesToRead;
    }

    @Override
    public long skip(long n) {
        int bytesToRemove = Math.min((int)n, this.buffer.available());
        this.buffer.removeData(bytesToRemove);
        return bytesToRemove;
    }

    @Override
    public int available() {
        return this.buffer.available();
    }

    @Override
    public void close() {
    }
}

