/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.openecard.bouncycastle.tls.Certificate;
import org.openecard.bouncycastle.tls.DigitallySigned;
import org.openecard.bouncycastle.tls.ProtocolVersion;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.TlsContext;
import org.openecard.bouncycastle.tls.TlsCredentials;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsKeyExchange;
import org.openecard.bouncycastle.tls.TlsUtils;

public abstract class AbstractTlsKeyExchange
implements TlsKeyExchange {
    protected int keyExchange;
    protected Vector supportedSignatureAlgorithms;
    protected TlsContext context;

    protected AbstractTlsKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms) {
        this.keyExchange = keyExchange;
        this.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
    }

    protected void checkServerCertSigAlg(Certificate serverCertificate) throws IOException {
        if (this.supportedSignatureAlgorithms == null) {
            // empty if block
        }
    }

    protected DigitallySigned parseSignature(InputStream input) throws IOException {
        DigitallySigned signature = DigitallySigned.parse(this.context, input);
        SignatureAndHashAlgorithm signatureAlgorithm = signature.getAlgorithm();
        if (signatureAlgorithm != null) {
            TlsUtils.verifySupportedSignatureAlgorithm(this.supportedSignatureAlgorithms, signatureAlgorithm);
        }
        return signature;
    }

    @Override
    public void init(TlsContext context) {
        block8: {
            ProtocolVersion clientVersion;
            block7: {
                this.context = context;
                clientVersion = context.getClientVersion();
                if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion)) break block7;
                if (this.supportedSignatureAlgorithms != null) break block8;
                switch (this.keyExchange) {
                    case 3: 
                    case 7: 
                    case 22: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultDSSSignatureAlgorithms();
                        break block8;
                    }
                    case 16: 
                    case 17: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultECDSASignatureAlgorithms();
                        break block8;
                    }
                    case 1: 
                    case 5: 
                    case 9: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 23: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultRSASignatureAlgorithms();
                        break block8;
                    }
                    case 13: 
                    case 14: 
                    case 21: 
                    case 24: {
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException("unsupported key exchange algorithm");
                    }
                }
            }
            if (this.supportedSignatureAlgorithms != null) {
                throw new IllegalStateException("supported_signature_algorithms not allowed for " + clientVersion);
            }
        }
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.processServerCertificate(serverCredentials.getCertificate());
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return false;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(80);
        }
        return null;
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void skipClientCredentials() throws IOException {
        if (TlsUtils.isStaticKeyAgreement(this.keyExchange)) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean requiresCertificateVerify() {
        return !TlsUtils.isStaticKeyAgreement(this.keyExchange);
    }
}

