/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.crypto.xmss;

import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.openecard.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import org.openecard.bouncycastle.pqc.crypto.xmss.XMSSUtil;

public final class XMSSPublicKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSParameters params;
    private final byte[] root;
    private final byte[] publicSeed;

    private XMSSPublicKeyParameters(Builder builder) {
        super(false);
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getDigestSize();
        byte[] publicKey = builder.publicKey;
        if (publicKey != null) {
            int rootSize = n;
            int publicSeedSize = n;
            int totalSize = rootSize + publicSeedSize;
            if (publicKey.length != totalSize) {
                throw new IllegalArgumentException("public key has wrong size");
            }
            int position = 0;
            this.root = XMSSUtil.extractBytesAtOffset(publicKey, position, rootSize);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(publicKey, position += rootSize, publicSeedSize);
        } else {
            byte[] tmpRoot = builder.root;
            if (tmpRoot != null) {
                if (tmpRoot.length != n) {
                    throw new IllegalArgumentException("length of root must be equal to length of digest");
                }
                this.root = tmpRoot;
            } else {
                this.root = new byte[n];
            }
            byte[] tmpPublicSeed = builder.publicSeed;
            if (tmpPublicSeed != null) {
                if (tmpPublicSeed.length != n) {
                    throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
                }
                this.publicSeed = tmpPublicSeed;
            } else {
                this.publicSeed = new byte[n];
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        int n;
        int rootSize = n = this.params.getDigestSize();
        int publicSeedSize = n;
        int totalSize = rootSize + publicSeedSize;
        byte[] out = new byte[totalSize];
        int position = 0;
        XMSSUtil.copyBytesAtOffset(out, this.root, position);
        XMSSUtil.copyBytesAtOffset(out, this.publicSeed, position += rootSize);
        return out;
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public XMSSParameters getParameters() {
        return this.params;
    }

    public static class Builder {
        private final XMSSParameters params;
        private byte[] root = null;
        private byte[] publicSeed = null;
        private byte[] publicKey = null;

        public Builder(XMSSParameters params) {
            this.params = params;
        }

        public Builder withRoot(byte[] val) {
            this.root = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.publicSeed = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicKey(byte[] val) {
            this.publicKey = XMSSUtil.cloneArray(val);
            return this;
        }

        public XMSSPublicKeyParameters build() {
            return new XMSSPublicKeyParameters(this);
        }
    }
}

