/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import org.openecard.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.openecard.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.openecard.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import org.openecard.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.openecard.bouncycastle.util.Arrays;

public final class XMSSMTPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSMTParameters params;
    private final long index;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final BDSStateMap bdsState;

    private XMSSMTPrivateKeyParameters(Builder builder) {
        super(true);
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getDigestSize();
        byte[] privateKey = builder.privateKey;
        if (privateKey != null) {
            if (builder.xmss == null) {
                throw new NullPointerException("xmss == null");
            }
            int totalHeight = this.params.getHeight();
            int indexSize = (totalHeight + 7) / 8;
            int secretKeySize = n;
            int secretKeyPRFSize = n;
            int publicSeedSize = n;
            int rootSize = n;
            int position = 0;
            this.index = XMSSUtil.bytesToXBigEndian(privateKey, position, indexSize);
            if (!XMSSUtil.isIndexValid(totalHeight, this.index)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(privateKey, position += indexSize, secretKeySize);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(privateKey, position += secretKeySize, secretKeyPRFSize);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(privateKey, position += secretKeyPRFSize, publicSeedSize);
            this.root = XMSSUtil.extractBytesAtOffset(privateKey, position += publicSeedSize, rootSize);
            byte[] bdsStateBinary = XMSSUtil.extractBytesAtOffset(privateKey, position += rootSize, privateKey.length - position);
            BDSStateMap bdsImport = null;
            try {
                bdsImport = (BDSStateMap)XMSSUtil.deserialize(bdsStateBinary);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            bdsImport.setXMSS(builder.xmss);
            this.bdsState = bdsImport;
        } else {
            this.index = builder.index;
            byte[] tmpSecretKeySeed = builder.secretKeySeed;
            if (tmpSecretKeySeed != null) {
                if (tmpSecretKeySeed.length != n) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = tmpSecretKeySeed;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byte[] tmpSecretKeyPRF = builder.secretKeyPRF;
            if (tmpSecretKeyPRF != null) {
                if (tmpSecretKeyPRF.length != n) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = tmpSecretKeyPRF;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byte[] tmpPublicSeed = builder.publicSeed;
            if (tmpPublicSeed != null) {
                if (tmpPublicSeed.length != n) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = tmpPublicSeed;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] tmpRoot = builder.root;
            if (tmpRoot != null) {
                if (tmpRoot.length != n) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = tmpRoot;
            } else {
                this.root = new byte[n];
            }
            BDSStateMap tmpBDSState = builder.bdsState;
            if (tmpBDSState != null) {
                this.bdsState = tmpBDSState;
            } else {
                long globalIndex = builder.index;
                int totalHeight = this.params.getHeight();
                this.bdsState = XMSSUtil.isIndexValid(totalHeight, globalIndex) && tmpPublicSeed != null && tmpSecretKeySeed != null ? new BDSStateMap(this.params, builder.index, tmpPublicSeed, tmpSecretKeySeed) : new BDSStateMap();
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        int n = this.params.getDigestSize();
        int indexSize = (this.params.getHeight() + 7) / 8;
        int secretKeySize = n;
        int secretKeyPRFSize = n;
        int publicSeedSize = n;
        int rootSize = n;
        int totalSize = indexSize + secretKeySize + secretKeyPRFSize + publicSeedSize + rootSize;
        byte[] out = new byte[totalSize];
        int position = 0;
        byte[] indexBytes = XMSSUtil.toBytesBigEndian(this.index, indexSize);
        XMSSUtil.copyBytesAtOffset(out, indexBytes, position);
        XMSSUtil.copyBytesAtOffset(out, this.secretKeySeed, position += indexSize);
        XMSSUtil.copyBytesAtOffset(out, this.secretKeyPRF, position += secretKeySize);
        XMSSUtil.copyBytesAtOffset(out, this.publicSeed, position += secretKeyPRFSize);
        XMSSUtil.copyBytesAtOffset(out, this.root, position += publicSeedSize);
        byte[] bdsStateOut = null;
        try {
            bdsStateOut = XMSSUtil.serialize(this.bdsState);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error serializing bds state");
        }
        return Arrays.concatenate(out, bdsStateOut);
    }

    public long getIndex() {
        return this.index;
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    BDSStateMap getBDSState() {
        return this.bdsState;
    }

    public XMSSMTParameters getParameters() {
        return this.params;
    }

    public XMSSMTPrivateKeyParameters getNextKey() {
        BDSStateMap newState = new BDSStateMap(this.bdsState, this.params, this.getIndex(), this.publicSeed, this.secretKeySeed);
        return new Builder(this.params).withIndex(this.index + 1L).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withBDSState(newState).build();
    }

    public static class Builder {
        private final XMSSMTParameters params;
        private long index = 0L;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private BDSStateMap bdsState = null;
        private byte[] privateKey = null;
        private XMSSParameters xmss = null;

        public Builder(XMSSMTParameters params) {
            this.params = params;
        }

        public Builder withIndex(long val) {
            this.index = val;
            return this;
        }

        public Builder withSecretKeySeed(byte[] val) {
            this.secretKeySeed = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] val) {
            this.secretKeyPRF = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.publicSeed = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withRoot(byte[] val) {
            this.root = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withBDSState(BDSStateMap val) {
            this.bdsState = val;
            return this;
        }

        public Builder withPrivateKey(byte[] privateKeyVal, XMSSParameters xmssVal) {
            this.privateKey = XMSSUtil.cloneArray(privateKeyVal);
            this.xmss = xmssVal;
            return this;
        }

        public XMSSMTPrivateKeyParameters build() {
            return new XMSSMTPrivateKeyParameters(this);
        }
    }
}

