/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.crypto.newhope;

import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.pqc.crypto.ExchangePair;
import org.openecard.bouncycastle.pqc.crypto.ExchangePairGenerator;
import org.openecard.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import org.openecard.bouncycastle.pqc.crypto.newhope.NewHope;

public class NHExchangePairGenerator
implements ExchangePairGenerator {
    private final SecureRandom random;

    public NHExchangePairGenerator(SecureRandom random) {
        this.random = random;
    }

    @Override
    public ExchangePair GenerateExchange(AsymmetricKeyParameter senderPublicKey) {
        return this.generateExchange(senderPublicKey);
    }

    @Override
    public ExchangePair generateExchange(AsymmetricKeyParameter senderPublicKey) {
        NHPublicKeyParameters pubKey = (NHPublicKeyParameters)senderPublicKey;
        byte[] sharedValue = new byte[32];
        byte[] publicKeyValue = new byte[2048];
        NewHope.sharedB(this.random, sharedValue, publicKeyValue, pubKey.pubData);
        return new ExchangePair(new NHPublicKeyParameters(publicKeyValue), sharedValue);
    }
}

