/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.openecard.bouncycastle.math.ec.ECCurve;
import org.openecard.bouncycastle.math.ec.ECFieldElement;
import org.openecard.bouncycastle.math.ec.ECPoint;
import org.openecard.bouncycastle.math.ec.custom.sec.SecP224R1FieldElement;
import org.openecard.bouncycastle.math.ec.custom.sec.SecP224R1Point;
import org.openecard.bouncycastle.util.encoders.Hex;

public class SecP224R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001"));
    private static final int SecP224R1_DEFAULT_COORDS = 2;
    protected SecP224R1Point infinity = new SecP224R1Point(this, null, null);

    public SecP224R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP224R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecP224R1FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecP224R1Point((ECCurve)this, x, y, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecP224R1Point(this, x, y, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }
}

