/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jsse.provider;

import org.openecard.bouncycastle.jsse.provider.PropertyUtils;
import org.openecard.bouncycastle.tls.DefaultTlsDHConfigVerifier;
import org.openecard.bouncycastle.tls.crypto.TlsDHConfig;

class ProvDHConfigVerifier
extends DefaultTlsDHConfigVerifier {
    private static final int provMinimumPrimeBits = PropertyUtils.getIntegerSystemProperty("org.openecard.bouncycastle.jsse.client.dh.minimumPrimeBits", 2048, 1024, 16384);
    private static final boolean provUnrestrictedGroups = PropertyUtils.getBooleanSystemProperty("org.openecard.bouncycastle.jsse.client.dh.unrestrictedGroups", false);

    ProvDHConfigVerifier() {
        super(provMinimumPrimeBits);
    }

    @Override
    protected boolean checkGroup(TlsDHConfig dhConfig) {
        return provUnrestrictedGroups || super.checkGroup(dhConfig);
    }
}

