/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.dvcs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openecard.bouncycastle.asn1.dvcs.CertEtcToken;
import org.openecard.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import org.openecard.bouncycastle.asn1.dvcs.DVCSTime;
import org.openecard.bouncycastle.asn1.dvcs.Data;
import org.openecard.bouncycastle.asn1.dvcs.ServiceType;
import org.openecard.bouncycastle.asn1.dvcs.TargetEtcChain;
import org.openecard.bouncycastle.asn1.x509.Extension;
import org.openecard.bouncycastle.cert.X509CertificateHolder;
import org.openecard.bouncycastle.dvcs.DVCSException;
import org.openecard.bouncycastle.dvcs.DVCSRequest;
import org.openecard.bouncycastle.dvcs.DVCSRequestBuilder;
import org.openecard.bouncycastle.dvcs.TargetChain;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder cert) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, cert.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date requestTime) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(requestTime));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

