/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.dvcs;

import java.io.OutputStream;
import org.openecard.bouncycastle.asn1.x509.DigestInfo;
import org.openecard.bouncycastle.dvcs.DVCSException;
import org.openecard.bouncycastle.dvcs.MessageImprint;
import org.openecard.bouncycastle.operator.DigestCalculator;

public class MessageImprintBuilder {
    private final DigestCalculator digestCalculator;

    public MessageImprintBuilder(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public MessageImprint build(byte[] message) throws DVCSException {
        try {
            OutputStream dOut = this.digestCalculator.getOutputStream();
            dOut.write(message);
            dOut.close();
            return new MessageImprint(new DigestInfo(this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
        }
        catch (Exception e) {
            throw new DVCSException("unable to build MessageImprint: " + e.getMessage(), e);
        }
    }
}

