/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.cms.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.cms.CMSException;
import org.openecard.bouncycastle.cms.KeyTransRecipientId;
import org.openecard.bouncycastle.cms.RecipientOperator;
import org.openecard.bouncycastle.cms.jcajce.JceKTSKeyTransRecipient;
import org.openecard.bouncycastle.jcajce.io.MacOutputStream;
import org.openecard.bouncycastle.operator.GenericKey;
import org.openecard.bouncycastle.operator.MacCalculator;
import org.openecard.bouncycastle.operator.jcajce.JceGenericKey;

public class JceKTSKeyTransAuthenticatedRecipient
extends JceKTSKeyTransRecipient {
    public JceKTSKeyTransAuthenticatedRecipient(PrivateKey recipientKey, KeyTransRecipientId recipientId) throws IOException {
        super(recipientKey, JceKTSKeyTransAuthenticatedRecipient.getPartyVInfoFromRID(recipientId));
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentMacAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        final Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentMacAlgorithm, encryptedContentEncryptionKey);
        final Mac dataMac = this.contentHelper.createContentMac(secretKey, contentMacAlgorithm);
        return new RecipientOperator(new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentMacAlgorithm;
            }

            @Override
            public GenericKey getKey() {
                return new JceGenericKey(contentMacAlgorithm, secretKey);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream(dataMac);
            }

            @Override
            public byte[] getMac() {
                return dataMac.doFinal();
            }
        });
    }
}

