/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.cms.bc;

import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.cms.CMSException;
import org.openecard.bouncycastle.cms.KEKRecipient;
import org.openecard.bouncycastle.cms.bc.CMSUtils;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.operator.OperatorException;
import org.openecard.bouncycastle.operator.SymmetricKeyUnwrapper;
import org.openecard.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;

public abstract class BcKEKRecipient
implements KEKRecipient {
    private SymmetricKeyUnwrapper unwrapper;

    public BcKEKRecipient(BcSymmetricKeyUnwrapper unwrapper) {
        this.unwrapper = unwrapper;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        try {
            return CMSUtils.getBcKey(this.unwrapper.generateUnwrappedKey(contentEncryptionAlgorithm, encryptedContentEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

