/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.cms;

import java.io.IOException;
import org.openecard.bouncycastle.asn1.cms.KEKIdentifier;
import org.openecard.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.cms.AuthAttributesProvider;
import org.openecard.bouncycastle.cms.CMSException;
import org.openecard.bouncycastle.cms.CMSSecureReadable;
import org.openecard.bouncycastle.cms.KEKRecipient;
import org.openecard.bouncycastle.cms.KEKRecipientId;
import org.openecard.bouncycastle.cms.Recipient;
import org.openecard.bouncycastle.cms.RecipientInformation;
import org.openecard.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

