/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.asn1.dvcs;

import java.io.IOException;
import org.openecard.bouncycastle.asn1.ASN1Choice;
import org.openecard.bouncycastle.asn1.ASN1Object;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.ASN1TaggedObject;
import org.openecard.bouncycastle.asn1.DERTaggedObject;
import org.openecard.bouncycastle.asn1.dvcs.DVCSCertInfo;
import org.openecard.bouncycastle.asn1.dvcs.DVCSErrorNotice;

public class DVCSResponse
extends ASN1Object
implements ASN1Choice {
    private DVCSCertInfo dvCertInfo;
    private DVCSErrorNotice dvErrorNote;

    public DVCSResponse(DVCSCertInfo dvCertInfo) {
        this.dvCertInfo = dvCertInfo;
    }

    public DVCSResponse(DVCSErrorNotice dvErrorNote) {
        this.dvErrorNote = dvErrorNote;
    }

    public static DVCSResponse getInstance(Object obj) {
        if (obj == null || obj instanceof DVCSResponse) {
            return (DVCSResponse)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return DVCSResponse.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Sequence) {
            DVCSCertInfo dvCertInfo = DVCSCertInfo.getInstance(obj);
            return new DVCSResponse(dvCertInfo);
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject t = ASN1TaggedObject.getInstance(obj);
            DVCSErrorNotice dvErrorNote = DVCSErrorNotice.getInstance(t, false);
            return new DVCSResponse(dvErrorNote);
        }
        throw new IllegalArgumentException("Couldn't convert from object to DVCSResponse: " + obj.getClass().getName());
    }

    public static DVCSResponse getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DVCSResponse.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public DVCSCertInfo getCertInfo() {
        return this.dvCertInfo;
    }

    public DVCSErrorNotice getErrorNotice() {
        return this.dvErrorNote;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.dvCertInfo != null) {
            return this.dvCertInfo.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, this.dvErrorNote);
    }

    public String toString() {
        if (this.dvCertInfo != null) {
            return "DVCSResponse {\ndvCertInfo: " + this.dvCertInfo.toString() + "}\n";
        }
        return "DVCSResponse {\ndvErrorNote: " + this.dvErrorNote.toString() + "}\n";
    }
}

