/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import generated.TCTokenType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;
import org.openecard.binding.tctoken.ConnectionError;
import org.openecard.binding.tctoken.SaveEServiceCertHandler;
import org.openecard.binding.tctoken.TCToken;
import org.openecard.binding.tctoken.TCTokenRequest;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.bouncycastle.tls.BasicTlsPSKIdentity;
import org.openecard.bouncycastle.tls.ProtocolVersion;
import org.openecard.bouncycastle.tls.TlsClient;
import org.openecard.bouncycastle.tls.TlsClientProtocol;
import org.openecard.bouncycastle.tls.crypto.TlsCrypto;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.openecard.common.I18nKey;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.UrlBuilder;
import org.openecard.crypto.common.ReusableSecureRandom;
import org.openecard.crypto.tls.ClientCertDefaultTlsClient;
import org.openecard.crypto.tls.ClientCertPSKTlsClient;
import org.openecard.crypto.tls.ClientCertTlsClient;
import org.openecard.crypto.tls.auth.CredentialFactory;
import org.openecard.crypto.tls.auth.DynamicAuthentication;
import org.openecard.crypto.tls.auth.SmartCardCredentialFactory;
import org.openecard.crypto.tls.proxy.ProxySettings;
import org.openecard.crypto.tls.verify.JavaSecVerifier;
import org.openecard.crypto.tls.verify.SameCertVerifier;

public class TlsConnectionHandler {
    private final Dispatcher dispatcher;
    private final TCTokenRequest tokenRequest;
    private final ConnectionHandleType handle;
    private URL serverAddress;
    private String hostname;
    private int port;
    private String resource;
    private String sessionId;
    private ClientCertTlsClient tlsClient;
    private boolean verifyCertificates = true;

    public TlsConnectionHandler(Dispatcher dispatcher, TCTokenRequest tokenRequest, ConnectionHandleType handle) throws ConnectionError {
        this.dispatcher = dispatcher;
        this.tokenRequest = tokenRequest;
        this.handle = handle;
    }

    public TlsConnectionHandler(Dispatcher dispatcher, TCTokenRequest tokenRequest) throws ConnectionError {
        this(dispatcher, tokenRequest, null);
    }

    public void setUpClient() throws ConnectionError {
        try {
            TCToken token = this.tokenRequest.getTCToken();
            String cardType = null;
            if (this.handle != null) {
                if (this.handle.getRecognitionInfo() != null) {
                    cardType = this.handle.getRecognitionInfo().getCardType();
                }
                if (cardType == null) {
                    cardType = this.tokenRequest.getCardType();
                }
            }
            boolean doSni = !"http://bsi.bund.de/cif/npa.xml".equals(cardType);
            this.sessionId = token.getSessionIdentifier();
            this.serverAddress = new URL(token.getServerAddress());
            String serverHost = this.serverAddress.getHost();
            if (Boolean.valueOf(OpenecardProperties.getProperty("legacy.session")).booleanValue()) {
                this.serverAddress = TlsConnectionHandler.fixServerAddress(this.serverAddress, this.sessionId);
            }
            this.hostname = this.serverAddress.getHost();
            this.port = this.serverAddress.getPort();
            if (this.port == -1) {
                this.port = this.serverAddress.getDefaultPort();
            }
            this.resource = this.serverAddress.getFile();
            this.resource = this.resource.isEmpty() ? "/" : this.resource;
            String secProto = token.getPathSecurityProtocol();
            if (this.isSameChannel()) {
                this.tlsClient = this.tokenRequest.getTokenContext().getTlsClient();
                if (this.tlsClient instanceof ClientCertDefaultTlsClient) {
                    ((ClientCertDefaultTlsClient)this.tlsClient).setEnforceSameSession(true);
                }
            } else {
                if (this.tokenRequest.getTokenContext() != null) {
                    this.tokenRequest.getTokenContext().closeStream();
                }
                ProtocolVersion version = ProtocolVersion.TLSv12;
                ProtocolVersion minVersion = ProtocolVersion.TLSv12;
                switch (secProto) {
                    case "urn:ietf:rfc:5246": {
                        break;
                    }
                    case "urn:ietf:rfc:4279": {
                        minVersion = ProtocolVersion.TLSv11;
                    }
                }
                DynamicAuthentication tlsAuth = new DynamicAuthentication(serverHost);
                BcTlsCrypto crypto = new BcTlsCrypto(ReusableSecureRandom.getInstance());
                switch (secProto) {
                    case "urn:ietf:rfc:4279": {
                        byte[] psk = token.getPathSecurityParameters().getPSK();
                        BasicTlsPSKIdentity pskId = new BasicTlsPSKIdentity(this.sessionId, psk);
                        this.tlsClient = new ClientCertPSKTlsClient((TlsCrypto)crypto, pskId, serverHost, doSni);
                        this.tlsClient.setClientVersion(version);
                        this.tlsClient.setMinimumVersion(minVersion);
                        break;
                    }
                    case "urn:ietf:rfc:5246": {
                        tlsAuth.setCredentialFactory(this.makeSmartCardCredential());
                        this.tlsClient = new ClientCertDefaultTlsClient((TlsCrypto)crypto, serverHost, doSni);
                        this.tlsClient.setClientVersion(version);
                        this.tlsClient.setMinimumVersion(minVersion);
                        if (!this.verifyCertificates) break;
                        tlsAuth.addCertificateVerifier(new JavaSecVerifier());
                        break;
                    }
                    default: {
                        throw new ConnectionError((I18nKey)ErrorTranslations.UNKNOWN_SEC_PROTOCOL, secProto);
                    }
                }
                tlsAuth.addCertificateVerifier(new SameCertVerifier());
                tlsAuth.addCertificateVerifier(new SaveEServiceCertHandler());
                this.tlsClient.setAuthentication(tlsAuth);
            }
        }
        catch (MalformedURLException ex) {
            throw new ConnectionError((I18nKey)ErrorTranslations.MALFORMED_URL, (Throwable)ex, "ServerAddress");
        }
    }

    public boolean isSameChannel() {
        TCToken token = this.tokenRequest.getTCToken();
        String secProto = token.getPathSecurityProtocol();
        if (secProto == null || "".equals(secProto)) {
            return true;
        }
        if (secProto.equals("urn:ietf:rfc:4279")) {
            TCTokenType.PathSecurityParameters pathsecParams = token.getPathSecurityParameters();
            return pathsecParams == null || pathsecParams.getPSK() == null || pathsecParams.getPSK().length == 0;
        }
        return false;
    }

    public void setVerifyCertificates(boolean verifyCertificates) {
        this.verifyCertificates = verifyCertificates;
    }

    public URL getServerAddress() {
        return this.serverAddress;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getResource() {
        return this.resource;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public TlsClient getTlsClient() {
        return this.tlsClient;
    }

    public TlsClientProtocol createTlsConnection() throws IOException, URISyntaxException {
        return this.createTlsConnection(this.tlsClient.getClientVersion());
    }

    public TlsClientProtocol createTlsConnection(ProtocolVersion tlsVersion) throws IOException, URISyntaxException {
        if (!this.isSameChannel()) {
            return this.createNewTlsConnection(tlsVersion);
        }
        TlsClientProtocol proto = this.tokenRequest.getTokenContext().getTlsClientProto();
        if (proto.isClosed()) {
            return this.createNewTlsConnection(tlsVersion);
        }
        return proto;
    }

    private TlsClientProtocol createNewTlsConnection(ProtocolVersion tlsVersion) throws IOException, URISyntaxException {
        Socket socket = ProxySettings.getDefault().getSocket("https", this.hostname, this.port);
        this.tlsClient.setClientVersion(tlsVersion);
        InputStream sockIn = socket.getInputStream();
        OutputStream sockOut = socket.getOutputStream();
        TlsClientProtocol handler = new TlsClientProtocol(sockIn, sockOut);
        handler.connect(this.tlsClient);
        return handler;
    }

    private static URL fixServerAddress(URL serverAddress, String sessionIdentifier) throws MalformedURLException {
        try {
            UrlBuilder b = UrlBuilder.fromUrl(serverAddress);
            return b.queryParam("sessionid", sessionIdentifier, false).build().toURL();
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException(ex.getMessage());
        }
    }

    @Nullable
    private CredentialFactory makeSmartCardCredential() {
        if (this.handle != null) {
            SmartCardCredentialFactory scFac = new SmartCardCredentialFactory(this.dispatcher, this.handle, true);
            return scFac;
        }
        return null;
    }
}

