/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.openecard.binding.tctoken.ResourceContext;
import org.openecard.binding.tctoken.ResourceException;
import org.openecard.binding.tctoken.TCToken;
import org.openecard.binding.tctoken.TCTokenHacks;
import org.openecard.binding.tctoken.TCTokenParser;
import org.openecard.binding.tctoken.TCTokenVerifier;
import org.openecard.binding.tctoken.ValidationError;
import org.openecard.binding.tctoken.ex.AuthServerException;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.InvalidAddressException;
import org.openecard.binding.tctoken.ex.InvalidRedirectUrlException;
import org.openecard.binding.tctoken.ex.InvalidTCTokenElement;
import org.openecard.binding.tctoken.ex.InvalidTCTokenException;
import org.openecard.binding.tctoken.ex.InvalidTCTokenUrlException;
import org.openecard.binding.tctoken.ex.SecurityViolationException;
import org.openecard.binding.tctoken.ex.TCTokenRetrievalException;
import org.openecard.binding.tctoken.ex.UserCancellationException;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18nKey;
import org.openecard.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCTokenContext
extends ResourceContext {
    private static final Logger LOG = LoggerFactory.getLogger(TCTokenContext.class);
    private final TCToken token;

    private TCTokenContext(TCToken token, ResourceContext base) {
        super(base.getTlsClient(), base.getTlsClientProto(), base.getCerts());
        this.token = token;
    }

    public TCToken getToken() {
        return this.token;
    }

    public static TCTokenContext generateTCToken(URL tcTokenURL) throws InvalidTCTokenException, AuthServerException, InvalidRedirectUrlException, InvalidTCTokenElement, InvalidTCTokenUrlException, SecurityViolationException, InvalidAddressException, UserCancellationException {
        try {
            ResourceContext ctx = ResourceContext.getStream(tcTokenURL);
            return TCTokenContext.generateTCToken(ctx.getData(), ctx);
        }
        catch (IOException | ResourceException | ValidationError ex) {
            throw new TCTokenRetrievalException((I18nKey)ErrorTranslations.RETRIEVAL_FAILED, (Throwable)ex, new Object[0]);
        }
    }

    public static TCTokenContext generateTCToken(String data) throws InvalidTCTokenException, AuthServerException, InvalidRedirectUrlException, InvalidTCTokenElement, InvalidTCTokenUrlException, SecurityViolationException, UserCancellationException {
        return TCTokenContext.generateTCToken(data, new ResourceContext(null, null, Collections.EMPTY_LIST));
    }

    private static TCTokenContext generateTCToken(String data, ResourceContext base) throws InvalidTCTokenException, AuthServerException, InvalidRedirectUrlException, InvalidTCTokenElement, InvalidTCTokenUrlException, SecurityViolationException, UserCancellationException {
        data = TCTokenHacks.fixPathSecurityParameters(data);
        LOG.debug("Cleaned up TCToken:\n{}", (Object)data);
        TCTokenParser parser = new TCTokenParser();
        List<TCToken> tokens = parser.parse(data);
        if (tokens.isEmpty()) {
            throw new InvalidTCTokenException((I18nKey)ErrorTranslations.NO_TCTOKEN_IN_DATA, new Object[0]);
        }
        TCToken token = tokens.get(0);
        TCTokenVerifier ver = new TCTokenVerifier(token, base);
        if (ver.isErrorToken()) {
            String minor = "clientError";
            throw new AuthServerException(token.getComErrorAddressWithParams(minor), (I18nKey)ErrorTranslations.ESERVICE_ERROR, new Object[0]);
        }
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        List<Pair<URL, TlsServerCertificate>> resultPoints = base.getCerts();
        if (!resultPoints.isEmpty()) {
            Pair<URL, TlsServerCertificate> last = resultPoints.get(0);
            dynCtx.put("TCTokenURL", last.p1);
        }
        ver.verifyUrlToken();
        return new TCTokenContext(token, base);
    }
}

