/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import java.net.MalformedURLException;
import java.net.URL;
import org.openecard.binding.tctoken.CertificateValidator;
import org.openecard.binding.tctoken.ValidationError;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18nKey;
import org.openecard.common.util.Promise;
import org.openecard.common.util.TR03112Utils;
import org.openecard.crypto.common.asn1.cvc.CertificateDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectCertificateValidator
implements CertificateValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectCertificateValidator.class);
    private final Promise<Object> descPromise;
    private final boolean redirectChecks;
    private boolean certDescExists;
    private URL lastURL;

    public RedirectCertificateValidator(boolean redirectChecks) {
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        this.descPromise = dynCtx.getPromise("eservice_certificate_description");
        this.redirectChecks = redirectChecks;
    }

    @Override
    public CertificateValidator.VerifierResult validate(URL url, TlsServerCertificate cert) throws ValidationError {
        try {
            if (this.redirectChecks) {
                URL sopUrl;
                CertificateDescription desc = (CertificateDescription)this.descPromise.derefNonblocking();
                boolean bl = this.certDescExists = desc != null;
                if (this.certDescExists && !TR03112Utils.isInCommCertificates(cert, desc.getCommCertificates())) {
                    LOG.error("The retrieved server certificate is NOT contained in the CommCertificates of the CertificateDescription extension of the eService certificate.");
                    throw new ValidationError((I18nKey)ErrorTranslations.INVALID_REDIRECT, new Object[0]);
                }
                if (this.certDescExists && desc.getSubjectURL() != null && !desc.getSubjectURL().isEmpty()) {
                    sopUrl = new URL(desc.getSubjectURL());
                } else {
                    DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
                    sopUrl = (URL)dynCtx.get("TCTokenURL");
                }
                if (this.lastURL == null) {
                    this.lastURL = url;
                }
                boolean SOP = TR03112Utils.checkSameOriginPolicy(this.lastURL, sopUrl);
                this.lastURL = url;
                if (!SOP) {
                    return CertificateValidator.VerifierResult.CONTINUE;
                }
                return CertificateValidator.VerifierResult.FINISH;
            }
            return CertificateValidator.VerifierResult.FINISH;
        }
        catch (MalformedURLException ex) {
            throw new ValidationError((I18nKey)ErrorTranslations.REDIRECT_MALFORMED_URL, (Throwable)ex, new Object[0]);
        }
    }
}

