/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.impl.io;

import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.annotation.Contract;
import org.openecard.apache.http.annotation.ThreadingBehavior;
import org.openecard.apache.http.impl.io.DefaultHttpResponseWriter;
import org.openecard.apache.http.io.HttpMessageWriter;
import org.openecard.apache.http.io.HttpMessageWriterFactory;
import org.openecard.apache.http.io.SessionOutputBuffer;
import org.openecard.apache.http.message.BasicLineFormatter;
import org.openecard.apache.http.message.LineFormatter;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseWriterFactory
implements HttpMessageWriterFactory<HttpResponse> {
    public static final DefaultHttpResponseWriterFactory INSTANCE = new DefaultHttpResponseWriterFactory();
    private final LineFormatter lineFormatter;

    public DefaultHttpResponseWriterFactory(LineFormatter lineFormatter) {
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
    }

    public DefaultHttpResponseWriterFactory() {
        this(null);
    }

    @Override
    public HttpMessageWriter<HttpResponse> create(SessionOutputBuffer buffer) {
        return new DefaultHttpResponseWriter(buffer, this.lineFormatter);
    }
}

