/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.impl.io;

import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpRequestFactory;
import org.openecard.apache.http.annotation.Contract;
import org.openecard.apache.http.annotation.ThreadingBehavior;
import org.openecard.apache.http.config.MessageConstraints;
import org.openecard.apache.http.impl.DefaultHttpRequestFactory;
import org.openecard.apache.http.impl.io.DefaultHttpRequestParser;
import org.openecard.apache.http.io.HttpMessageParser;
import org.openecard.apache.http.io.HttpMessageParserFactory;
import org.openecard.apache.http.io.SessionInputBuffer;
import org.openecard.apache.http.message.BasicLineParser;
import org.openecard.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

