/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addons.tr03124.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.openecard.addons.tr03124.gui.CardMonitorTask;
import org.openecard.common.I18n;
import org.openecard.common.interfaces.CardRecognition;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.Radiobox;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;

public class CardSelectionStep
extends Step {
    private static final String ID = "CredentialSelection";
    private final TreeMap<String, ConnectionHandleType> avCardWithName = new TreeMap();
    private final I18n lang = I18n.getTranslation("tr03112");
    private final CardRecognition rec;

    public CardSelectionStep(@Nonnull String title, @Nonnull List<ConnectionHandleType> availableCards, @Nonnull CardRecognition rec) {
        super(ID, title);
        this.setReversible(false);
        for (ConnectionHandleType conHandle : availableCards) {
            this.avCardWithName.put(rec.getTranslatedCardName(conHandle.getRecognitionInfo().getCardType()), conHandle);
        }
        this.rec = rec;
        this.addElements();
    }

    private void addElements() {
        Text description = new Text();
        description.setText(this.lang.translationForKey("card.selection.message", new Object[0]));
        Radiobox radioBox = new Radiobox("credentialSelectionBox");
        radioBox.setGroupText("Available Credentials");
        for (String cardName : this.avCardWithName.keySet()) {
            BoxItem item = new BoxItem();
            item.setName(this.avCardWithName.get(cardName).getRecognitionInfo().getCardType());
            item.setText(cardName);
            radioBox.getBoxItems().add(item);
        }
        this.getInputInfoUnits().add(description);
        this.getInputInfoUnits().add(radioBox);
    }

    public void update(List<ConnectionHandleType> availableCards) {
        ConnectionHandleType handle2;
        this.avCardWithName.clear();
        for (ConnectionHandleType handle2 : availableCards) {
            this.avCardWithName.put(this.rec.getTranslatedCardName(handle2.getRecognitionInfo().getCardType()), handle2);
        }
        CardMonitorTask task = (CardMonitorTask)this.getBackgroundTask();
        if (task != null && (handle2 = task.getResult()).getRecognitionInfo() != null && handle2.getRecognitionInfo().getCardType() != null) {
            this.avCardWithName.put(this.rec.getTranslatedCardName(handle2.getRecognitionInfo().getCardType()), handle2);
        }
        this.getInputInfoUnits().clear();
        this.addElements();
    }
}

