/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addons.status;

import java.util.List;
import java.util.Map;
import org.openecard.addon.Context;
import org.openecard.addon.EventHandler;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.Attachment;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.bind.Headers;
import org.openecard.addon.bind.RequestBody;
import org.openecard.addons.status.StatusException;
import org.openecard.addons.status.WaitForChangeRequest;
import org.openecard.addons.status.WaitForChangeResponse;
import org.openecard.ws.schema.StatusChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForChangeAction
implements AppPluginAction {
    private static final Logger LOG = LoggerFactory.getLogger(WaitForChangeAction.class);
    private EventHandler eventHandler;

    @Override
    public void init(Context ctx) {
        this.eventHandler = ctx.getEventHandler();
    }

    @Override
    public void destroy() {
        this.eventHandler = null;
    }

    @Override
    public BindingResult execute(RequestBody body, Map<String, String> parameters, Headers headers, List<Attachment> attachments) {
        BindingResult response;
        try {
            WaitForChangeRequest statusRequest = WaitForChangeRequest.convert(parameters);
            StatusChange status = this.eventHandler.next(statusRequest.getSessionIdentifier());
            response = new WaitForChangeResponse(status);
        }
        catch (StatusException e) {
            response = new BindingResult(BindingResultCode.WRONG_PARAMETER);
            response.setResultMessage(e.getMessage());
        }
        catch (Exception e) {
            response = new BindingResult(BindingResultCode.INTERNAL_ERROR);
            LOG.error(e.getMessage(), e);
        }
        return response;
    }
}

